% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappings.R
\name{mapping_key}
\alias{mapping_key}
\alias{unnest_mappings}
\alias{mapping_groups}
\title{Return partition mapping key}
\usage{
mapping_key(.partition)

unnest_mappings(.partition)

mapping_groups(.partition, indices = FALSE)
}
\arguments{
\item{.partition}{a \code{partition} object}

\item{indices}{logical. Return just the indices instead of the names? Default is \code{FALSE}.}
}
\value{
a \code{tibble}
}
\description{
\code{mapping_key()} returns a data frame with each reduced variable and its
mapping and information loss; the mapping and indices are represented as
\code{list-cols} (so there is one row per variable in the reduced data set).
\code{unnest_mappings()} unnests the list columns to return a tidy data frame.
\code{mapping_groups()} returns a list of mappings (either the variable names or
their column position).
}
\examples{
set.seed(123)
df <- simulate_block_data(c(3, 4, 5), lower_corr = .4, upper_corr = .6, n = 100)
# fit partition
prt <- partition(df, threshold = .6)

# tibble: 6 x 4
mapping_key(prt)

# tibble: 12 x 4
unnest_mappings(prt)

# list: length 6
mapping_groups(prt)

}
