% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location_slice.R
\name{location_slice}
\alias{location_slice}
\title{Extract local climate for one or more locations for a given time slice.}
\usage{
location_slice(
  x,
  time_bp = NULL,
  bio_variables,
  dataset,
  path_to_nc = NULL,
  nn_interpol = TRUE,
  buffer = FALSE,
  directions = 8
)
}
\arguments{
\item{x}{a data.frame with columns `longitude`, ranging
-180 to 180, and `latitude`, from -90 to 90, plus optional
columns `time_bp` and `name`. Alternatively, a vector of cell numbers.}

\item{time_bp}{used if no `time_bp` column is present in `x`: the dates in
years before present (negative
values represent time before present, i.e. 1950, positive values time in the future)
for each location.}

\item{bio_variables}{vector of names of variables to be extracted.}

\item{dataset}{string defining the dataset to use. If set to "custom",
then a single nc file is used from "path_to_nc"}

\item{path_to_nc}{the path to the custom nc file containing the palaeoclimate
reconstructions. All the variables of interest need to be included in
this file.}

\item{nn_interpol}{boolean determining whether nearest neighbour
interpolation is used to estimate climate for cells that lack such
information (i.e. they are under water or ice). By default, interpolation is only
performed from the first ring of nearest neighbours; if climate is not
available, NA will be returned for that location. The number of neighbours
can be changed with the argument `directions`. `nn_interpol` defaults to TRUE.}

\item{buffer}{boolean determining whether the variable will be returned
as the mean of a buffer around the focal cell. If set to TRUE, it overrides
`nn_interpol` (which provides the same estimates as `buffer` but only for
locations that are in cells with an NA). The buffer size is determined
by the argument `directions`. `buffer` defaults to FALSE.}

\item{directions}{character or matrix to indicate the directions in which
cells are considered connected when using `nn_interpol` or `buffer`. 
The following character values are allowed: "rook" or "4" for the 
horizontal and vertical neighbors; "bishop" to get the diagonal neighbors;
"queen" or "8" to get the vertical, horizontal and diagonal neighbors;
or "16" for knight and one-cell queen move neighbors. If directions
is a matrix it should have odd dimensions and have logical (or 0, 1) values.}
}
\value{
a data.frame with the climatic variables of interest.
}
\description{
This function extract local climate for a set of locations
at the appropriate times (selecting the closest time slice available for the
specific date associated with each location).
}
