% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_from_sea.R
\name{distance_from_sea}
\alias{distance_from_sea}
\title{Compute a raster of distances from the sea for each land pixel.}
\usage{
distance_from_sea(time_bp = NULL, time_ce = NULL, dataset)
}
\arguments{
\item{time_bp}{time slice in years before present (negative)}

\item{time_ce}{time slice in years CE.
Only one of \code{time_bp} or \code{time_ce} should be used.}

\item{dataset}{string defining the dataset to use (a list of possible
values can be obtained with \code{\link[=list_available_datasets]{list_available_datasets()}}). This function
will not work on custom datasets.}
}
\value{
a \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} of distances from the coastline in km
}
\description{
Get the land mask for a dataset at a given time point, and compute distance
from the sea for each land pixel.
}
