% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_etopo.R
\name{download_etopo}
\alias{download_etopo}
\title{Download the ETOPO Global relief model}
\usage{
download_etopo(path = NULL, resolution = 60)
}
\arguments{
\item{path}{character. Path where to download the data to. If left NULL, the data
will be downloaded from the directory returned by \code{\link[=get_data_path]{get_data_path()}}, and automatically
named \verb{etopo2022_\{resolution\}s_v1.nc}}

\item{resolution}{numeric resolution in arcsecs (one of 30, or 60).
Defaults to 60 arcsecs.}
}
\value{
a dataframe produced by \code{\link[curl:multi_download]{curl::multi_download()}} with information about
the download (including error codes)
}
\description{
This function downloads the ETOPO2022 global relief model at 30 or 60 arcsecs
resolution. This is a large file (>1Gb).
}
\keyword{internal}
