% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_data_path.R
\name{set_data_path}
\alias{set_data_path}
\title{Set the data path where climate reconstructions will be stored}
\usage{
set_data_path(
  path_to_nc = NULL,
  ask = TRUE,
  write_config = TRUE,
  copy_example = TRUE,
  on_CRAN = FALSE
)
}
\arguments{
\item{path_to_nc}{the path to the file that contains the downloaded
reconstructions. If left unset, the default location returned by
\code{tools::R_user_dir("pastclim","data")} will be used}

\item{ask}{boolean on whether the user should be asked to confirm their
choices}

\item{write_config}{boolean on whether the path should be saved in a config
file}

\item{copy_example}{boolean on whether the example dataset should be saved
in the data_path}

\item{on_CRAN}{boolean; users should NOT need this parameters. It is used to set up a
data path in the temporary directory for examples and tests
to run on CRAN.}
}
\value{
TRUE if the path was set correctly
}
\description{
This function sets the path where climate reconstructions will be stored.
This
information is stored in a file names "pastclim_data.txt", which is found
in the directory returned by \code{tools::R_user_dir("pastclim","config")} (i.e.
the default configuration directory for the package as set in R >= 4.0).
}
