% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmetic.R
\name{plot_arithmetic}
\alias{plot_arithmetic}
\alias{-.ggplot}
\alias{/.ggplot}
\alias{|.ggplot}
\alias{*.gg}
\alias{&.gg}
\title{Plot arithmetic}
\usage{
\method{-}{ggplot}(e1, e2)

\method{/}{ggplot}(e1, e2)

\method{|}{ggplot}(e1, e2)

\method{*}{gg}(e1, e2)

\method{&}{gg}(e1, e2)
}
\arguments{
\item{e1}{A \code{ggplot} or \code{patchwork} object}

\item{e2}{A \code{ggplot} or \code{patchwork} object in case of \code{/}, or a \code{gg} object
such as a geom or theme specification in case of \code{*} and \code{&}}
}
\value{
A \code{patchwork} object
}
\description{
In addition to the \code{+} operator known in \code{ggplot2}, \code{patchwork} defines logic
for some of the other operators that aids in building up your plot
composition and reduce code-reuse.
}
\details{
\code{patchwork} augment the \code{+} operator from \code{ggplot2} and allows the user to
add full \code{ggplot} objects together in order to compose them into the same
view. The last added plot is always the active one where new geoms etc. are
added to. Another operator that is much like it, but not quite, is \code{-}. It
also adds plots together but instead of adding the right hand side to the
patchwork defined in the left hand side, it puts the left hand side besides
the right hand side in a patchwork. This might sound confusing, but in
essence \code{-} ensures that the right and left side are put in the same nesting
level (\code{+} puts the right side \emph{into} the left side). Using \code{-} might seem
unintuitive if you think of the operator as "subtrack", but look at it as a
hyphen instead (the underlying reason is that \code{-} is the only operator in the
same precedence group as \code{+}).

Often you are interested in creating single column or single row layouts.
\code{patchwork} provides \code{|} (besides) and \code{/} (over) operators to support
stacking and packing of plots. See the exampels for their use.

In order to reduce code repetition \code{patchwork} provides two operators for
adding ggplot elements (geoms, themes, facets, etc.) to multiple/all plots in
a patchwork. \code{*} will add the element to all plots in the current nesting
level, while \code{&} will recurse into nested patches.
}
\examples{
library(ggplot2)

p1 <- ggplot(mtcars) + geom_point(aes(mpg, disp))
p2 <- ggplot(mtcars) + geom_boxplot(aes(gear, disp, group = gear))
p3 <- ggplot(mtcars) + geom_bar(aes(gear)) + facet_wrap(~cyl)
p4 <- ggplot(mtcars) + geom_bar(aes(carb))

# Standard addition vs division
p1 + p2 + p3 + plot_layout(ncol = 1)
p1 + p2 - p3 + plot_layout(ncol = 1)

# Stacking and packing
(p1 | p2 | p3) /
      p4

# Add elements to the same nesting level
(p1 + (p2 + p3) + p4 + plot_layout(ncol = 1)) * theme_bw()

# Recurse into nested plots as well
(p1 + (p2 + p3) + p4 + plot_layout(ncol = 1)) & theme_bw()

}
