% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{RA_output}
\alias{RA_output}
\title{Example Output for the pathfindR Enrichment Workflow - Rheumatoid Arthritis}
\format{A data frame with 33 rows and 8 columns:
\describe{
  \item{ID}{KEGG ID of the enriched pathway}
  \item{Pathway}{Description of the enriched pathway}
  \item{Fold_Enrichment}{Fold enrichment value for the enriched pathway}
  \item{occurrence}{the number of iterations that the given pathway was found to enriched over all iterations}
  \item{lowest_p}{the lowest adjusted-p value of the given pathway over all iterations}
  \item{highest_p}{the highest adjusted-p value of the given pathway over all iterations}
  \item{Up_regulated}{the up-regulated genes in the input involved in the given pathway, comma-separated}
  \item{Down_regulated}{the down-regulated genes in the input involved in the given pathway, comma-separated}
}}
\usage{
RA_output
}
\description{
A dataset containing the results of pathfindR's active-subnetwork-oriented
pathway enrichment workflow performed on the rheumatoid arthritis
differential-expression dataset \code{RA_input}. Active subnetwork search
was performed with Greedy Algorithm using the Biogrid PIN.
}
\seealso{
\code{\link{RA_input}} for example input of the enrichment workflow.
\code{\link{RA_clustered}} for example output of the clustering workflow.
}
\keyword{datasets}
