% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{calculate_pw_scores}
\alias{calculate_pw_scores}
\title{Calculate Pathway Scores for Each Subject}
\usage{
calculate_pw_scores(pw_table, exp_mat, cases = NULL, plot_hmap = TRUE,
  ...)
}
\arguments{
\item{pw_table}{a data frame that must contain the 3 columns below:\describe{
  \item{Pathway}{Description of the enriched pathway}
  \item{Up_regulated}{the up-regulated genes in the input involved in the given pathway, comma-separated}
  \item{Down_regulated}{the down-regulated genes in the input involved in the given pathway, comma-separated}
}}

\item{exp_mat}{the gene expression/methylation matrix. Columns are samples
and rows are genes. Column names must contain sample names and row names must
contain the gene symbols.}

\item{cases}{(Optional) A vector of sample names that are cases in the
case/control experiment.}

\item{plot_hmap}{Boolean value to indicate whether or not to draw the
heatmap plot of the scores. (default = TRUE)}

\item{...}{Addtional arguments for `plot_scores` for aesthetics of the heatmap plot}
}
\value{
Matrix of pathway scores per sample. Columns are samples, rows are
pathways. Optionally, displays a heatmap of this matrix.
}
\description{
Calculate Pathway Scores for Each Subject
}
\examples{
score_matrix <- calculate_pw_scores(RA_output, RA_exp_mat, plot_hmap = FALSE)
}
