% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_functions.R
\name{UpSet_plot}
\alias{UpSet_plot}
\title{Create UpSet Plot of Enriched Terms}
\usage{
UpSet_plot(
  result_df,
  genes_df,
  num_terms = 10,
  method = "heatmap",
  use_description = FALSE,
  low = "red",
  mid = "black",
  high = "green",
  ...
)
}
\arguments{
\item{result_df}{A dataframe of pathfindR results that must contain the following columns: \describe{
  \item{Term_Description}{Description of the enriched term (necessary if \code{use_description = TRUE})}
  \item{ID}{ID of the enriched term (necessary if \code{use_description = FALSE})}
  \item{lowest_p}{the highest adjusted-p value of the given term over all iterations}
  \item{Up_regulated}{the up-regulated genes in the input involved in the given term's gene set, comma-separated}
  \item{Down_regulated}{the down-regulated genes in the input involved in the given term's gene set, comma-separated}
}}

\item{genes_df}{the input data that was used with \code{\link{run_pathfindR}}.
  It must be a data frame with 3 columns: \enumerate{
  \item Gene Symbol (Gene Symbol)
  \item Change value, e.g. log(fold change) (optional)
  \item p value, e.g. adjusted p value associated with differential expression
} The change values in this data frame are used to color the affected genes}

\item{num_terms}{Number of top enriched terms to use while creating the plot. Set to \code{NULL} to use
all enriched terms (default = 10)}

\item{method}{the option for producing the plot. Options include "heatmap",
"boxplot" and "barplot". (default = "heatmap")}

\item{use_description}{Boolean argument to indicate whether term descriptions
(in the "Term_Description" column) should be used. (default = \code{FALSE})}

\item{low}{a string indicating the color of 'low' values in the coloring gradient (default = 'green')}

\item{mid}{a string indicating the color of 'mid' values in the coloring gradient (default = 'black')}

\item{high}{a string indicating the color of 'high' values in the coloring gradient (default = 'red')}

\item{...}{additional arguments for \code{\link{input_processing}} (used if
\code{genes_df} is provided)}
}
\value{
UpSet plots are plots of the intersections of sets as a matrix. This
function creates a ggplot object of an UpSet plot where the x-axis is the
UpSet plot of intersections of enriched terms. By default (i.e.
\code{method = "heatmap"}) the main plot is a heatmap of genes at the
corresponding intersections, colored by up/down regulation (if
\code{genes_df} is provided, colored by change values). If
\code{method = "barplot"}, the main plot is bar plots of the number of genes
at the corresponding intersections. Finally, if \code{method = "boxplot"} and
if \code{genes_df} is provided, then the main plot displays the boxplots of
change values of the genes at the corresponding intersections.
}
\description{
Create UpSet Plot of Enriched Terms
}
\examples{
UpSet_plot(RA_comparison_output)
}
