% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udfs.R
\name{tx_property_of}
\alias{tx_property_of}
\title{Get properties for codings}
\usage{
tx_property_of(
  coding,
  property_code,
  property_type = "string",
  accept_language = NULL
)
}
\arguments{
\item{coding}{A Column containing a struct representation of a Coding.}

\item{property_code}{The code of the property to retrieve.}

\item{property_type}{The type of the property to retrieve.}

\item{accept_language}{The optional language preferences for the returned property values.
Overrides the parameter `accept_language` in `PathlingContext.create`.}
}
\value{
The Column containing the result of the operation (array of property values).
}
\description{
Takes a Coding column as its input. Returns a Column that contains the values of properties
for this coding with specified names and types. The type of the result column depends on the
types of the properties. Primitive FHIR types are mapped to their corresponding SQL primitives.
Complex types are mapped to their corresponding structs.
}
\examples{
\dontshow{if (pathling_is_spark_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pc <- pathling_connect()

# Get the (first) value of the `inactive` property of the first coding of the Condition resource.
pc \%>\% pathling_example_resource('Condition') \%>\%
     sparklyr::mutate(id, 
         is_inavtive = (!!tx_property_of(code[['coding']][[0]], 
                                 "inactive",PropertyType$BOOLEAN))[[0]], 
         .keep='none'
     )

pathling_disconnect(pc)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{PropertyType}}

\href{https://pathling.csiro.au/docs/libraries/terminology#retrieving-properties}{Pathling documentation - Retrieving properties}

Other terminology functions: 
\code{\link{tx_display}()},
\code{\link{tx_member_of}()},
\code{\link{tx_subsumed_by}()},
\code{\link{tx_subsumes}()},
\code{\link{tx_translate}()}
}
\concept{terminology functions}
