% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subjectProfileIntervalPlot.R
\name{subjectProfileIntervalPlot}
\alias{subjectProfileIntervalPlot}
\title{Visualize time interval in subject profiles,
so event with a start and end time.}
\usage{
subjectProfileIntervalPlot(
  data,
  paramVar,
  paramVarSep = " - ",
  paramLab = getLabelVar(paramVar, labelVars = labelVars),
  paramGroupVar = NULL,
  timeStartVar,
  timeStartLab = getLabelVar(timeStartVar, labelVars = labelVars),
  timeEndVar,
  timeEndLab = getLabelVar(timeEndVar, labelVars = labelVars),
  timeLabel = "time",
  timeLab = toString(c(timeStartLab, timeEndLab)),
  subjectVar = "USUBJID",
  subjectSubset = NULL,
  subjectSample = NULL,
  seed = 123,
  subsetData = NULL,
  subsetVar = NULL,
  subsetValue = NULL,
  timeImpType = c("minimal", "data-based", "none"),
  timeLim = NULL,
  timeLimData = NULL,
  timeLimStartVar = NULL,
  timeLimStartLab = getLabelVar(timeLimStartVar, labelVars = labelVars),
  timeLimEndVar = NULL,
  timeLimEndLab = getLabelVar(timeLimEndVar, labelVars = labelVars),
  timeTrans = NULL,
  timeExpand = NULL,
  timeAlign = TRUE,
  xLab = timeLab,
  yLab = "",
  colorVar = NULL,
  colorLab = getLabelVar(colorVar, labelVars = labelVars),
  colorPalette = NULL,
  alpha = 1,
  timeStartShapeVar = NULL,
  timeEndShapeVar = NULL,
  shapePalette = NULL,
  shapeLab = toString(unique(getLabelVar(c(timeStartShapeVar, timeEndShapeVar),
    labelVars = labelVars))),
  shapeSize = rel(3),
  title = toString(getLabelVar(paramVar, labelVars = labelVars, label = paramLab)),
  label = title,
  labelVars = NULL,
  formatReport = subjectProfileReportFormat(),
  paging = TRUE
)
}
\arguments{
\item{data}{Data.frame with data.}

\item{paramVar}{Character vector with variable(s) of \code{data} 
with parameters. Variable content is displayed in the y-axis.}

\item{paramVarSep}{string with character(s) used to concatenate multiple 
\code{paramVar}, ' - ' by default.}

\item{paramLab}{Named character vector, 
with label for the parameter variable(s) (\code{paramVar}).\cr
This is used to set the default title.}

\item{paramGroupVar}{(optional) Character vector with variable(s) 
of \code{data} based on which the data will be grouped and sorted 
(in the y-axis) in the plot.}

\item{timeStartVar}{String, variable of \code{data} 
with start of time interval.}

\item{timeStartLab}{String, label for \code{timeStartVar},
displayed in a message and in the plot caption.}

\item{timeEndVar}{String, variable of \code{data} 
with end of time interval.}

\item{timeEndLab}{String, label for \code{timeEndVar},
displayed in a message and in the plot caption.}

\item{timeLabel}{This parameter is deprecated, use \code{timeLab} instead.}

\item{timeLab}{String, label for \code{timeVar}.
This is used in the message
indicating missing values for \code{timeVar},
and for the default label of the x-axis.}

\item{subjectVar}{String, variable of \code{data} with subject ID}

\item{subjectSubset}{(optional) Character vector with subjects of interest 
(available in \code{subjectVar}), NULL by default.}

\item{subjectSample}{(optional) Integer of length 1
with number of random subject(s) that should be considered,
e.g. to check the created patient profiles for a subset of the data.
By default, all specified subjects are considered (set to NULL).}

\item{seed}{(optional) Integer of length 1 with seed used to select random subjects 
if \code{subjectSample} is specified (123 by default).}

\item{subsetData}{(optional) Data.frame with extra dataset to filter on.
This dataset is filtered, and only records from \code{data} 
with common subject IDs will be retained.\cr
If not specified, \code{data} is used.}

\item{subsetVar}{(optional) String with variable of subset data to filter on.
\code{subsetValue} should be specified too.\cr
If not specified, all records from the subset data are retained.}

\item{subsetValue}{(optional) Character vector with value(s) of interest to
retain in the filtered data.
These values should be available in \code{subsetVar}.\cr
Missing values in the subject variable are not retained 
in the filtered data.}

\item{timeImpType}{String with imputation type: 'minimal' (default),
'data-based' or 'none', see section: 'Time interval representation'.\cr
This imputation type is not used if a dataset used to impute time is 
specified.}

\item{timeLim}{(optional) Vector of length 2 with time limits (x-axis).
If not specified, these are extracted from the minimum \code{timeStartVar} 
and maximum \code{timeEndVar} per subject.\cr
The time limits are stored as attributes of the plots,
used to align the plots in the final report.}

\item{timeLimData}{Data.frame with data used to impute time
in case some time records are missing in \code{data}, 
see section: 'Time interval representation'.}

\item{timeLimStartVar}{String, variable of \code{timeLimData} with 
start of the time interval.}

\item{timeLimStartLab}{String, label for \code{timeLimeStartVar},
displayed in a message and in the plot caption.}

\item{timeLimEndVar}{String, variable of \code{timeLimData} with 
end of the time interval.}

\item{timeLimEndLab}{String, label for \code{timeLimEndVar},
displayed in a message and in the plot caption.}

\item{timeTrans}{transformation for the time variable, 
(see \code{trans} parameter in \code{\link[ggplot2]{scale_x_continuous}}, and
\code{\link[scales]{trans_new}}).
For example, produced by the \code{\link{getTimeTrans}} function.}

\item{timeExpand}{Vector of range expansion constants for the time axis
(see \code{expand} parameter in \code{\link[ggplot2]{scale_x_continuous}}).}

\item{timeAlign}{Logical, if TRUE (by default)
the different plots are horizontally aligned.
If set to FALSE, each plot has its own time-limits.\cr
If set to FALSE, this is not compatible with 
the specification of \code{timeLim}.}

\item{xLab}{String, label for the x-axis.}

\item{yLab}{String, label for the y-axis.}

\item{colorVar}{String, variable of \code{data} with color,
used both for the point(s) and segment(s).}

\item{colorLab}{String, label for \code{colorVar}.}

\item{colorPalette}{Named vector with color palette.
The variable should be named with the corresponding element
in \code{colorVar}.\cr
Colors can also be defined for the entire session, by setting
\code{options(patientProfilesVis.colors = X)} with X either:
\itemize{
\item{a vector with colors}
\item{a function returning a vector of colors for a specified number
of elements (\code{viridis} by default)}
}}

\item{alpha}{Numeric with transparency, 1 by default.}

\item{timeStartShapeVar}{(optional) String, variable of \code{data} 
used for the shape of the symbol displayed 
at the start of the time interval.\cr
If not specified, default shape palette is used,
see section 'Time interval representation'.}

\item{timeEndShapeVar}{String, variable of \code{data} 
used for the shape of the symbol 
displayed at the end of the time interval.
If not specified, default shape palette is used,
see section 'Time interval representation'.}

\item{shapePalette}{Named vector with (combined) shape palette for 
\code{timeStartShapeVar}\code{timeEndShapeVar}.}

\item{shapeLab}{String with label for \code{timeStartShapeVar}\code{timeEndShapeVar}}

\item{shapeSize}{Size for symbols (only used if \code{timeStartShapeVar}/\code{timeEndShapeVar} is specified).}

\item{title}{String with title, label of the parameter variable by default.}

\item{label}{String, label for the visualization.
This label is stored as attributes of the output
from the \code{subjectProfile[]Plot} function.\cr
This label is displayed in the final profile
report, in case no data is available for
for a specific patient, as: 'No [label] available.'}

\item{labelVars}{Named character vector with variable labels 
(names are the variable code)}

\item{formatReport}{list with parameters used to specify the format of the report,
e.g. output of the \code{\link{subjectProfileReportFormat}} function}

\item{paging}{Logical, if TRUE (by default), automatic 
paging is enabled, so patient profiles module too big to fit
in one page will span multiple pages.
Please note that the size of the graphic window 
(or report page) may need
to be re-sized in order that the plot fits.
\cr
If FALSE, the entire plot is included in one single page.}
}
\value{
list of (across subjects) of list (across pages) 
of \code{\link[ggplot2]{ggplot2} objects}, 
also of class \code{subjectProfileIntervalPlot}.
 with additional 'metaData' attributes containing
'\code{label}', 'timeLim' \code{timeTrans} and \code{timeExpand} (if specified).
}
\description{
Visualize time interval in subject profiles,
so event with a start and end time.
}
\section{Time interval representation}{

In case the start or the end of the time interval contain missing values:
\itemize{
\item{if a dataset (\code{timeLimData}), start (\code{timeLimStartVar})
and end (\code{timeLimEndVar}) variables are specified: }{
\enumerate{
\item{for each subject: }{
\itemize{
\item{the minimum and maximum time values across these specified time variables are extracted}
\item{missing start values are replaced by the minimum time}
\item{missing start values are replaced by the maximum time}
}}
\item{if all values are missing for this subject, they are taken across subjects}
}}
\item{otherwise, depending on the imputation type (\code{timeImpType}): }{
\itemize{
\item{'minimal' (by default): }{
\itemize{
\item{if the start and the end of the interval are missing: }{no imputation is done, only the label is displayed}
\item{if the start time is missing and the end time is not missing: }{
start time is imputed with end time, and status is set to 'Missing start'}
\item{if the end time is missing and the start time is not missing: }{
end time is imputed with start time, and status is set to 'Missing end'}
}}
\item{'data-based' (default in version < 1.0.0): }{
minimum/maximum values in the start/end time variables in the data are considered
for the specific subject (if available). If there are missing for a specific subject,
they are taken across subjects. If all time are missings, the range is set to 0 and Inf}
\item{'none': }{no imputation is done}
}}}
The symbols displayed at the start and end of the interval are:
\itemize{
\item{by default: }{
\itemize{
\item{a filled square labelled 'Complete' if the time is not missing}
\item{a filled left-directed arrow in case of missing start time}
\item{a filled right-directed arrow in case of missing end time}
}}
\item{if the variable(s) used for the shape of the start or end 
of the interval are specified (via \code{timeStartShapeVar}/\code{timeEndShapeVar}): }{
labels are based on these variables, and a standard shape palette is used}
}
The time limits are the same across subjects, and set to:
\itemize{
\item{\code{timeLim} if specified}
\item{maximum time range in \code{timeLimStartVar} and \code{timeLimEndVar} in \code{timeLimData} 
if specified}
\item{the maximum range on the data obtained after imputation of missing values}
}
}

\seealso{
Other patient profiles plotting function: 
\code{\link{subjectProfileEventPlot}()},
\code{\link{subjectProfileLinePlot}()},
\code{\link{subjectProfileTextPlot}()}
}
\author{
Laure Cougnaud
}
\concept{patient profiles plotting function}
