% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subjectProfileIntervalPlot.R
\name{formatTimeInterval}
\alias{formatTimeInterval}
\title{Set missing start/end time variable in the data.}
\usage{
formatTimeInterval(
  data,
  timeStartVar,
  timeStartLab = getLabelVar(timeStartVar, labelVars = labelVars),
  timeEndVar,
  timeEndLab = getLabelVar(timeEndVar, labelVars = labelVars),
  timeStartShapeVar = NULL,
  timeEndShapeVar = NULL,
  subjectVar = "USUBJID",
  timeLim = NULL,
  timeLimData = NULL,
  timeLimStartVar = NULL,
  timeLimStartLab = getLabelVar(timeLimStartVar, labelVars = labelVars),
  timeLimEndVar = NULL,
  timeLimEndLab = getLabelVar(timeLimEndVar, labelVars = labelVars),
  timeImpType = c("minimal", "data-based", "none"),
  labelVars = NULL
)
}
\arguments{
\item{data}{Data.frame with data.}

\item{timeStartVar}{String, variable of \code{data} 
with start of time interval.}

\item{timeStartLab}{String, label for \code{timeStartVar},
displayed in a message and in the plot caption.}

\item{timeEndVar}{String, variable of \code{data} 
with end of time interval.}

\item{timeEndLab}{String, label for \code{timeEndVar},
displayed in a message and in the plot caption.}

\item{timeStartShapeVar}{(optional) String, variable of \code{data} 
used for the shape of the symbol displayed 
at the start of the time interval.\cr
If not specified, default shape palette is used,
see section 'Time interval representation'.}

\item{timeEndShapeVar}{String, variable of \code{data} 
used for the shape of the symbol 
displayed at the end of the time interval.
If not specified, default shape palette is used,
see section 'Time interval representation'.}

\item{subjectVar}{String, variable of \code{data} with subject ID}

\item{timeLim}{(optional) Vector of length 2 with time limits (x-axis).
If not specified, these are extracted from the minimum \code{timeStartVar} 
and maximum \code{timeEndVar} per subject.\cr
The time limits are stored as attributes of the plots,
used to align the plots in the final report.}

\item{timeLimData}{Data.frame with data used to impute time
in case some time records are missing in \code{data}, 
see section: 'Time interval representation'.}

\item{timeLimStartVar}{String, variable of \code{timeLimData} with 
start of the time interval.}

\item{timeLimStartLab}{String, label for \code{timeLimeStartVar},
displayed in a message and in the plot caption.}

\item{timeLimEndVar}{String, variable of \code{timeLimData} with 
end of the time interval.}

\item{timeLimEndLab}{String, label for \code{timeLimEndVar},
displayed in a message and in the plot caption.}

\item{timeImpType}{String with imputation type: 'minimal' (default),
'data-based' or 'none', see section: 'Time interval representation'.\cr
This imputation type is not used if a dataset used to impute time is 
specified.}

\item{labelVars}{Named character vector with variable labels 
(names are the variable code)}
}
\value{
list with:
\itemize{
\item{'data': Data with:
\itemize{
\item{imputed \code{timeStartVar} and \code{timeEndVar}}
\item{new column 'timeStartStatus': 
character vector containing status of \code{timeStartVar} variable:
 'Complete' or 'Missing start' or NA}
\item{new column 'timeEndStatus': 
character vector containing status of \code{timeEndVar} variable:
 'Complete' or 'Missing end' or NA}
}}
\item{'timeLim': vector of length 2 with minimum/maximum time limits 
across subjects.}
\item{'timeLimSpecified': vector of length 2 with time limits as specified 
by the user, either extracted from \code{timeLim} or from \code{timeLimData}.
If missing value within \code{timeLim}, the corresponding minimum/maximum
value in the (updated) data is used.}
\item{'timeShapePalette': Named character vector with symbols for the 
different time status}
\item{'caption': String with extra explanation concerning imputation that 
could be included in plot caption.}
}
}
\description{
Set missing start/end time variable in the data.
}
\section{Time interval representation}{

In case the start or the end of the time interval contain missing values:
\itemize{
\item{if a dataset (\code{timeLimData}), start (\code{timeLimStartVar})
and end (\code{timeLimEndVar}) variables are specified: 
\enumerate{
\item{for each subject: 
\itemize{
\item{the minimum and maximum time values across these specified time 
variables are extracted}
\item{missing start values are replaced by the minimum time}
\item{missing start values are replaced by the maximum time}
}}
\item{if all values are missing for this subject, they are taken across subjects}
}}
\item{otherwise, depending on the imputation type (\code{timeImpType}):
\itemize{
\item{'minimal' (by default): 
\itemize{
\item{if the start and the end of the interval are missing: 
no imputation is done, only the label is displayed}
\item{if the start time is missing and the end time is not missing: 
start time is imputed with end time, and status is set to 'Missing start'}
\item{if the end time is missing and the start time is not missing: 
end time is imputed with start time, and status is set to 'Missing end'}
}}
\item{'data-based' (default in version < 1.0.0): 
minimum/maximum values in the start/end time variables in the data are considered
for the specific subject (if available). If there are missing for a specific subject,
they are taken across subjects. If all time are missings, the range is set to 0 and Inf}
\item{'none': no imputation is done}
}}}
The symbols displayed at the start and end of the interval are:
\itemize{
\item{by default: 
\itemize{
\item{a filled square labelled 'Complete' if the time is not missing}
\item{a filled left-directed arrow in case of missing start time}
\item{a filled right-directed arrow in case of missing end time}
}}
\item{if the variable(s) used for the shape of the start or end 
of the interval are specified (via 
\code{timeStartShapeVar}/\code{timeEndShapeVar}): 
labels are based on these variables, and a standard shape palette is used}
}
The time limits are the same across subjects, and set to:
\itemize{
\item{\code{timeLim} if specified}
\item{maximum time range in \code{timeLimStartVar} and 
\code{timeLimEndVar} in \code{timeLimData} 
if specified}
\item{the maximum range on the data obtained after imputation of missing 
values}
}
}

\author{
Laure Cougnaud
}
