% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{getShapePalettePatientProfile}
\alias{getShapePalettePatientProfile}
\title{Get a shape palette for patient profile
visualizations.}
\usage{
getShapePalettePatientProfile(..., includeNA = TRUE, asText = TRUE)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[clinUtils:getShapePalette]{clinUtils::getShapePalette}}
  \describe{
    \item{\code{n}}{Integer of length 1, number of elements in palette.}
    \item{\code{x}}{Vector with elements used for palette.
If factor, the levels are used, otherwise the unique elements of the vector.
Missing values are automatically removed, excepted if
\code{includeNA} is set to TRUE.}
    \item{\code{palette}}{A vector of custom shapes,
or a function returning this vector from a specific
number of shapes.\cr
The vector should be a character if \code{asText} is set to TRUE.\cr
Default is the \code{\link[clinUtils]{clinShapes}} shape palette,
or \code{\link[clinUtils]{clinShapesText}} if \code{asText} is set to TRUE.}
  }}

\item{includeNA}{Logical (TRUE by default), 
should NA elements be retained in the palette in case
\code{x} is specified?}

\item{asText}{Logical (TRUE by default), should the palette
be expressed as integer (base R plot and ggplot2 compatible)
or in text format 
(e.g. required if combined with unicode symbols in ggplot2)?}
}
\value{
Vector of shapes,
named with the elements in \code{x} if \code{x} is specified.
}
\description{
This is a simple wrapper around 
\link[clinUtils]{getShapePalette},
with different defaults:
\itemize{
\item{inclusion of missing values by
default (\code{includeNA} set to \code{TRUE})
}
\item{the extraction of shapes as text
by default (\code{asText} set to \code{TRUE})
}
}
}
\seealso{
\link[clinUtils]{getShapePalette}
}
\author{
Laure Cougnaud
}
