% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcEffect.R
\name{pcEffect}
\alias{pcEffect}
\title{Calculate and Summarize Pattern Causality Effects}
\usage{
pcEffect(pcmatrix)
}
\arguments{
\item{pcmatrix}{A list containing three matrices (\code{positive}, \code{negative}, and \code{dark}) which represent the respective causality types for different items, as well as an \code{items} vector indicating the names of the items.}
}
\value{
A list containing three data frames (\code{positive}, \code{negative}, and \code{dark}), each summarizing the causality effects. Each data frame includes columns for the received, exerted, and the difference (\code{Diff}) of causality for each item.
}
\description{
The \code{pcEffect} function processes a pattern causality matrix to compute and summarize the effects of positive, negative, and dark causality. It aggregates these causality measures to determine the total received and exerted influence for each item in the matrix, along with the difference between them.
}
\examples{
\donttest{
data(climate_indices)
dataset <- climate_indices[,-1]
pcmatrix <- pcMatrix(dataset, E = 3, tau = 1, metric = "euclidean", h = 1, weighted = TRUE)
effects <- pcEffect(pcmatrix)
print(effects)
}
}
