% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEffect.R
\name{plotEffect}
\alias{plotEffect}
\title{Visualize Pattern Causality Effects}
\usage{
plotEffect(effects, status, addlabel = TRUE)
}
\arguments{
\item{effects}{A list containing data frames of causality effects for positive, negative, and dark influences, as returned by the \code{pcEffect} function. Each data frame includes columns for received influence, exerted influence, and the difference between them.}

\item{status}{A character string specifying which causality effect to plot. Must be one of \code{"positive"}, \code{"negative"}, or \code{"dark"}.}

\item{addlabel}{A logical value indicating whether to add labels to the plot. Defaults to \code{TRUE}.}
}
\value{
A scatter plot visualizing the relationship between influence exerted and influence received for the specified causality type. The plot also includes color coding to represent the difference in influence.
}
\description{
The \code{plotEffect} function generates a plot to visualize the effects of positive, negative, or dark causality based on the results from the \code{pcEffect} function. It displays the influence exerted versus influence received for each item, providing a clear graphical representation of the causality effects.
}
\examples{
\donttest{
data(climate_indices)
dataset <- climate_indices[,-1]
pcmatrix <- pcMatrix(dataset, E = 3, tau = 1, metric = "euclidean", h = 1, weighted = TRUE)
effects <- pcEffect(pcmatrix)
plotEffect(effects, status = "positive", addlabel = TRUE)
}
}
