% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignReg.R
\name{alignReg}
\alias{alignReg}
\title{Aligns images using \code{\link[RNiftyReg]{niftyreg}} utilities for automated image registration..}
\usage{
alignReg(
  sampleList,
  target,
  resampleFactor = NULL,
  useBlockPercentage = 75,
  crop = c(0, 0, 0, 0),
  removebgR = NULL,
  maskOutline = NULL,
  plotTransformed = FALSE
)
}
\arguments{
\item{sampleList}{List of RasterStack objects.}

\item{target}{Image imported as RasterStack used as target for registration.}

\item{resampleFactor}{Integer for downsampling used by \code{\link{redRes}} (default = NULL).}

\item{useBlockPercentage}{Block percentage as used in \code{\link[RNiftyReg]{niftyreg}}
(default = 75).}

\item{crop}{Vector c(xmin, xmax, ymin, ymax) that specifies the pixel coordinates to crop the
original image.}

\item{removebgR}{Integer indicating the range RGB treshold to remove from image (e.g. 100 removes
pixels with average RGB > 100; default = NULL) for registration analysis. This works only to
remove a white background.}

\item{maskOutline}{When outline is specified, everything outside of the outline will be masked for
the color extraction (default = NULL).}

\item{plotTransformed}{Whether to plot transformed images while processing (default = FALSE).}
}
\value{
List of raster objects.
}
\description{
Aligns images using \code{\link[RNiftyReg]{niftyreg}} utilities for automated image registration..
}
