% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternring1.R
\name{patternring1}
\alias{patternring1}
\title{Plot a ring chart using patterns and colors to fill the ring.}
\usage{
patternring1(
  group1,
  pct1,
  label1,
  label.size1 = 4,
  label.color1 = "black",
  label.distance1 = 1.2,
  pattern.type1,
  pattern.color1,
  pattern.line.size1 = rep(10, length(group1)),
  background.color1,
  frame.color = "black",
  frame.size = 1,
  density1 = rep(10, length(group1)),
  pixel = 20,
  pattern.type.inner = "blank",
  pattern.color.inner = "white",
  pattern.line.size.inner = 1,
  background.color.inner = "white",
  pixel.inner = 10,
  density.inner = 1,
  r1,
  r2
)
}
\arguments{
\item{group1}{a vector of strings, containing the names of each slice.}

\item{pct1}{a vector of non-negative numbers, containing percentages of each group.
The numbers must sum up to 100.}

\item{label1}{a vector of strings, giving the names for the slices shown in the ring chart.}

\item{label.size1}{the font size of labels shown in the ring chart.}

\item{label.color1}{the color of labels shown in the ring chart.}

\item{label.distance1}{the distance of labels from the border of the ring chart.}

\item{pattern.type1}{a vector of patterns to be filled in the ring. 
The pattern types include: 'blank', 'bricks', 'vdashes', 'hdashes', 'crosshatch','dots', 
'grid','hlines','nelines', 'nwlines', 'vlines', 'waves' and more.}

\item{pattern.color1}{a vector of colors for the lines/dots of patterns filled in the ring.}

\item{pattern.line.size1}{a vector of numeric values, the line size for the lines/dots of patterns filled in the ring.}

\item{background.color1}{a vector of colors to be filled in the ring.}

\item{frame.color}{the color for the borders of the ring.}

\item{frame.size}{a numeric value, the line size for the borders of the ring.}

\item{density1}{a numeric vector, the density for the lines/dots of patterns of the ring.}

\item{pixel}{a numeric value, the pixel resolution of the ring.}

\item{pattern.type.inner}{a pattern to be filled in the inner circle.}

\item{pattern.color.inner}{the color for the lines/dots of the pattern of the inner circle.}

\item{pattern.line.size.inner}{the line size for the lines/dots of the pattern of the inner circle.}

\item{background.color.inner}{the color to be filled in the inner circle.}

\item{pixel.inner}{a numeric value, the pixel resolution of the inner circle.}

\item{density.inner}{a numeric vector, the density for the lines/dots of patterns of the inner circle.}

\item{r1}{a numeric value, the inner radius of the ring.}

\item{r2}{a numeric value, the outer radius of the ring.}
}
\value{
A ggplot object.
}
\description{
The \code{patternring1} function is a tool for creating versatile ring charts 
by filling the ring with colors and patterns.
}
\details{
\code{patternring1} function offers flexible ways of doing ring charts.
}
\examples{
library(patternplot)
library(png)
library(ggplot2)
group1<-c('New_England', 'Great_Lakes','Plains',  'Rocky_Mountain', 
          'Far_West','Southwest', 'Southeast',  'Mideast')
pct1<-c( 12, 11, 17, 15, 8, 11,  16,  10)
label1<-paste(group1, " \n ", pct1, "\%", sep="")

pattern.type1<-c("hdashes", "blank", "grid", "blank", "hlines", 
                 "blank", "waves", "blank")
pattern.type.inner<-"blank"
pattern.color1<-rep("white", 8)
background.color1<-c("darkgreen", "darkcyan", "chocolate", "cadetblue1", 
                     "darkorchid", "yellowgreen", "hotpink", "lightslateblue")
density1<-rep(12, length(group1))
pattern.line.size1=c(12, 1, 10, 1, 20, 1, 12, 1)

g<-patternring1(group1, pct1, label1, label.size1=4,label.color1='black', 
label.distance1=1.45, pattern.type1, pattern.color1, pattern.line.size1,
background.color1, frame.color='black',frame.size=1.2, density1, pixel=18,
pattern.type.inner="blank",pattern.color.inner="white", pattern.line.size.inner=1,
background.color.inner="white", pixel.inner=10, density.inner=1, r1=3, r2=4)
g<-g+annotate(geom="text", x=0, y=0,label="2019 Number of Cases \n N=1000",color="black",
size=4)+scale_x_continuous(limits=c(-7, 7))+scale_y_continuous(limits=c(-7, 7))
g

}
\seealso{
Function \code{imagering1}
}
\author{
Chunqiao Luo (chunqiaoluo@gmail.com)
}
