% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_list_table_metadata}
\alias{athena_list_table_metadata}
\title{Lists the metadata for the tables in the specified data catalog database}
\usage{
athena_list_table_metadata(CatalogName, DatabaseName, Expression,
  NextToken, MaxResults)
}
\arguments{
\item{CatalogName}{[required] The name of the data catalog for which table metadata should be
returned.}

\item{DatabaseName}{[required] The name of the database for which table metadata should be returned.}

\item{Expression}{A regex filter that pattern-matches table names. If no expression is
supplied, metadata for all tables are listed.}

\item{NextToken}{A token generated by the Athena service that specifies where to continue
pagination if a previous request was truncated. To obtain the next set
of pages, pass in the NextToken from the response object of the previous
page call.}

\item{MaxResults}{Specifies the maximum number of results to return.}
}
\description{
Lists the metadata for the tables in the specified data catalog
database.
}
\section{Request syntax}{
\preformatted{svc$list_table_metadata(
  CatalogName = "string",
  DatabaseName = "string",
  Expression = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
