% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_stop_delivery_stream_encryption}
\alias{firehose_stop_delivery_stream_encryption}
\title{Disables server-side encryption (SSE) for the delivery stream}
\usage{
firehose_stop_delivery_stream_encryption(DeliveryStreamName)
}
\arguments{
\item{DeliveryStreamName}{[required] The name of the delivery stream for which you want to disable
server-side encryption (SSE).}
}
\description{
Disables server-side encryption (SSE) for the delivery stream.

This operation is asynchronous. It returns immediately. When you invoke
it, Kinesis Data Firehose first sets the encryption status of the stream
to \code{DISABLING}, and then to \code{DISABLED}. You can continue to read and
write data to your stream while its status is \code{DISABLING}. It can take
up to 5 seconds after the encryption status changes to \code{DISABLED} before
all records written to the delivery stream are no longer subject to
encryption. To find out whether a record or a batch of records was
encrypted, check the response elements PutRecordOutput$Encrypted and
PutRecordBatchOutput$Encrypted, respectively.

To check the encryption state of a delivery stream, use
DescribeDeliveryStream.

If SSE is enabled using a customer managed CMK and then you invoke
\code{StopDeliveryStreamEncryption}, Kinesis Data Firehose schedules the
related KMS grant for retirement and then retires it after it ensures
that it is finished delivering records to the destination.

The \code{StartDeliveryStreamEncryption} and \code{StopDeliveryStreamEncryption}
operations have a combined limit of 25 calls per delivery stream per 24
hours. For example, you reach the limit if you call
\code{StartDeliveryStreamEncryption} 13 times and
\code{StopDeliveryStreamEncryption} 12 times for the same delivery stream in
a 24-hour period.
}
\section{Request syntax}{
\preformatted{svc$stop_delivery_stream_encryption(
  DeliveryStreamName = "string"
)
}
}

\keyword{internal}
