% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_get_named_query}
\alias{athena_get_named_query}
\title{Returns information about a single query}
\usage{
athena_get_named_query(NamedQueryId)
}
\arguments{
\item{NamedQueryId}{[required] The unique ID of the query. Use
\code{\link[=athena_list_named_queries]{list_named_queries}} to get query IDs.}
}
\value{
A list with the following syntax:\preformatted{list(
  NamedQuery = list(
    Name = "string",
    Description = "string",
    Database = "string",
    QueryString = "string",
    NamedQueryId = "string",
    WorkGroup = "string"
  )
)
}
}
\description{
Returns information about a single query. Requires that you have access
to the workgroup in which the query was saved.
}
\section{Request syntax}{
\preformatted{svc$get_named_query(
  NamedQueryId = "string"
)
}
}

\keyword{internal}
