% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_list_triggers}
\alias{glue_list_triggers}
\title{Retrieves the names of all trigger resources in this AWS account, or the
resources with the specified tag}
\usage{
glue_list_triggers(NextToken, DependentJobName, MaxResults, Tags)
}
\arguments{
\item{NextToken}{A continuation token, if this is a continuation request.}

\item{DependentJobName}{The name of the job for which to retrieve triggers. The trigger that can
start this job is returned. If there is no such trigger, all triggers
are returned.}

\item{MaxResults}{The maximum size of a list to return.}

\item{Tags}{Specifies to return only these tagged resources.}
}
\value{
A list with the following syntax:\preformatted{list(
  TriggerNames = list(
    "string"
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves the names of all trigger resources in this AWS account, or the
resources with the specified tag. This operation allows you to see which
resources are available in your account, and their names.

This operation takes the optional \code{Tags} field, which you can use as a
filter on the response so that tagged resources can be retrieved as a
group. If you choose to use tags filtering, only resources with the tag
are retrieved.
}
\section{Request syntax}{
\preformatted{svc$list_triggers(
  NextToken = "string",
  DependentJobName = "string",
  MaxResults = 123,
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
