# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include athena_service.R
NULL

#' Returns the details of a single named query or a list of up to 50
#' queries, which you provide as an array of query ID strings
#'
#' Returns the details of a single named query or a list of up to 50
#' queries, which you provide as an array of query ID strings. Requires you
#' to have access to the workgroup in which the queries were saved. Use
#' ListNamedQueriesInput to get the list of named query IDs in the
#' specified workgroup. If information could not be retrieved for a
#' submitted query ID, information about the query ID submitted is listed
#' under UnprocessedNamedQueryId. Named queries differ from executed
#' queries. Use BatchGetQueryExecutionInput to get details about each
#' unique query execution, and ListQueryExecutionsInput to get a list of
#' query execution IDs.
#'
#' @usage
#' athena_batch_get_named_query(NamedQueryIds)
#'
#' @param NamedQueryIds &#91;required&#93; An array of query IDs.
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_named_query(
#'   NamedQueryIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_batch_get_named_query
athena_batch_get_named_query <- function(NamedQueryIds) {
  op <- new_operation(
    name = "BatchGetNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$batch_get_named_query_input(NamedQueryIds = NamedQueryIds)
  output <- .athena$batch_get_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$batch_get_named_query <- athena_batch_get_named_query

#' Returns the details of a single query execution or a list of up to 50
#' query executions, which you provide as an array of query execution ID
#' strings
#'
#' Returns the details of a single query execution or a list of up to 50
#' query executions, which you provide as an array of query execution ID
#' strings. Requires you to have access to the workgroup in which the
#' queries ran. To get a list of query execution IDs, use
#' ListQueryExecutionsInput\\$WorkGroup. Query executions differ from named
#' (saved) queries. Use BatchGetNamedQueryInput to get details about named
#' queries.
#'
#' @usage
#' athena_batch_get_query_execution(QueryExecutionIds)
#'
#' @param QueryExecutionIds &#91;required&#93; An array of query execution IDs.
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_query_execution(
#'   QueryExecutionIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_batch_get_query_execution
athena_batch_get_query_execution <- function(QueryExecutionIds) {
  op <- new_operation(
    name = "BatchGetQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$batch_get_query_execution_input(QueryExecutionIds = QueryExecutionIds)
  output <- .athena$batch_get_query_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$batch_get_query_execution <- athena_batch_get_query_execution

#' Creates (registers) a data catalog with the specified name and
#' properties
#'
#' Creates (registers) a data catalog with the specified name and
#' properties. Catalogs created are visible to all users of the same AWS
#' account.
#'
#' @usage
#' athena_create_data_catalog(Name, Type, Description, Parameters, Tags)
#'
#' @param Name &#91;required&#93; The name of the data catalog to create. The catalog name must be unique
#' for the AWS account and can use a maximum of 128 alphanumeric,
#' underscore, at sign, or hyphen characters.
#' @param Type &#91;required&#93; The type of data catalog to create: `LAMBDA` for a federated catalog,
#' `GLUE` for AWS Glue Catalog, or `HIVE` for an external hive metastore.
#' @param Description A description of the data catalog to be created.
#' @param Parameters Specifies the Lambda function or functions to use for creating the data
#' catalog. This is a mapping whose values depend on the catalog type.
#' 
#' -   For the `HIVE` data catalog type, use the following syntax. The
#'     `metadata-function` parameter is required. `The sdk-version`
#'     parameter is optional and defaults to the currently supported
#'     version.
#' 
#'     `metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> `
#' 
#' -   For the `LAMBDA` data catalog type, use one of the following sets of
#'     required parameters, but not both.
#' 
#'     -   If you have one Lambda function that processes metadata and
#'         another for reading the actual data, use the following syntax.
#'         Both parameters are required.
#' 
#'         `metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> `
#' 
#'     -   If you have a composite Lambda function that processes both
#'         metadata and data, use the following syntax to specify your
#'         Lambda function.
#' 
#'         `function=<i>lambda_arn</i> `
#' 
#' -   The `GLUE` type has no parameters.
#' @param Tags A list of comma separated tags to add to the data catalog that is
#' created.
#'
#' @section Request syntax:
#' ```
#' svc$create_data_catalog(
#'   Name = "string",
#'   Type = "LAMBDA"|"GLUE"|"HIVE",
#'   Description = "string",
#'   Parameters = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_create_data_catalog
athena_create_data_catalog <- function(Name, Type, Description = NULL, Parameters = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDataCatalog",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_data_catalog_input(Name = Name, Type = Type, Description = Description, Parameters = Parameters, Tags = Tags)
  output <- .athena$create_data_catalog_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_data_catalog <- athena_create_data_catalog

#' Creates a named query in the specified workgroup
#'
#' Creates a named query in the specified workgroup. Requires that you have
#' access to the workgroup.
#' 
#' For code samples using the AWS SDK for Java, see [Examples and Code
#' Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html)
#' in the *Amazon Athena User Guide*.
#'
#' @usage
#' athena_create_named_query(Name, Description, Database, QueryString,
#'   ClientRequestToken, WorkGroup)
#'
#' @param Name &#91;required&#93; The query name.
#' @param Description The query description.
#' @param Database &#91;required&#93; The database to which the query belongs.
#' @param QueryString &#91;required&#93; The contents of the query with all query statements.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to create the
#' query is idempotent (executes only once). If another `CreateNamedQuery`
#' request is received, the same response is returned and another query is
#' not created. If a parameter has changed, for example, the `QueryString`,
#' an error is returned.
#' 
#' This token is listed as not required because AWS SDKs (for example the
#' AWS SDK for Java) auto-generate the token for users. If you are not
#' using the AWS SDK or the AWS CLI, you must provide this token or the
#' action will fail.
#' @param WorkGroup The name of the workgroup in which the named query is being created.
#'
#' @section Request syntax:
#' ```
#' svc$create_named_query(
#'   Name = "string",
#'   Description = "string",
#'   Database = "string",
#'   QueryString = "string",
#'   ClientRequestToken = "string",
#'   WorkGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_create_named_query
athena_create_named_query <- function(Name, Description = NULL, Database, QueryString, ClientRequestToken = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "CreateNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_named_query_input(Name = Name, Description = Description, Database = Database, QueryString = QueryString, ClientRequestToken = ClientRequestToken, WorkGroup = WorkGroup)
  output <- .athena$create_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_named_query <- athena_create_named_query

#' Creates a workgroup with the specified name
#'
#' Creates a workgroup with the specified name.
#'
#' @usage
#' athena_create_work_group(Name, Configuration, Description, Tags)
#'
#' @param Name &#91;required&#93; The workgroup name.
#' @param Configuration The configuration for the workgroup, which includes the location in
#' Amazon S3 where query results are stored, the encryption configuration,
#' if any, used for encrypting query results, whether the Amazon CloudWatch
#' Metrics are enabled for the workgroup, the limit for the amount of bytes
#' scanned (cutoff) per query, if it is specified, and whether workgroup\'s
#' settings (specified with EnforceWorkGroupConfiguration) in the
#' WorkGroupConfiguration override client-side settings. See
#' WorkGroupConfiguration\\$EnforceWorkGroupConfiguration.
#' @param Description The workgroup description.
#' @param Tags A list of comma separated tags to add to the workgroup that is created.
#'
#' @section Request syntax:
#' ```
#' svc$create_work_group(
#'   Name = "string",
#'   Configuration = list(
#'     ResultConfiguration = list(
#'       OutputLocation = "string",
#'       EncryptionConfiguration = list(
#'         EncryptionOption = "SSE_S3"|"SSE_KMS"|"CSE_KMS",
#'         KmsKey = "string"
#'       )
#'     ),
#'     EnforceWorkGroupConfiguration = TRUE|FALSE,
#'     PublishCloudWatchMetricsEnabled = TRUE|FALSE,
#'     BytesScannedCutoffPerQuery = 123,
#'     RequesterPaysEnabled = TRUE|FALSE
#'   ),
#'   Description = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_create_work_group
athena_create_work_group <- function(Name, Configuration = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_work_group_input(Name = Name, Configuration = Configuration, Description = Description, Tags = Tags)
  output <- .athena$create_work_group_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_work_group <- athena_create_work_group

#' Deletes a data catalog
#'
#' Deletes a data catalog.
#'
#' @usage
#' athena_delete_data_catalog(Name)
#'
#' @param Name &#91;required&#93; The name of the data catalog to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_data_catalog(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_delete_data_catalog
athena_delete_data_catalog <- function(Name) {
  op <- new_operation(
    name = "DeleteDataCatalog",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_data_catalog_input(Name = Name)
  output <- .athena$delete_data_catalog_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_data_catalog <- athena_delete_data_catalog

#' Deletes the named query if you have access to the workgroup in which the
#' query was saved
#'
#' Deletes the named query if you have access to the workgroup in which the
#' query was saved.
#' 
#' For code samples using the AWS SDK for Java, see [Examples and Code
#' Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html)
#' in the *Amazon Athena User Guide*.
#'
#' @usage
#' athena_delete_named_query(NamedQueryId)
#'
#' @param NamedQueryId &#91;required&#93; The unique ID of the query to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_named_query(
#'   NamedQueryId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_delete_named_query
athena_delete_named_query <- function(NamedQueryId) {
  op <- new_operation(
    name = "DeleteNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_named_query_input(NamedQueryId = NamedQueryId)
  output <- .athena$delete_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_named_query <- athena_delete_named_query

#' Deletes the workgroup with the specified name
#'
#' Deletes the workgroup with the specified name. The primary workgroup
#' cannot be deleted.
#'
#' @usage
#' athena_delete_work_group(WorkGroup, RecursiveDeleteOption)
#'
#' @param WorkGroup &#91;required&#93; The unique name of the workgroup to delete.
#' @param RecursiveDeleteOption The option to delete the workgroup and its contents even if the
#' workgroup contains any named queries.
#'
#' @section Request syntax:
#' ```
#' svc$delete_work_group(
#'   WorkGroup = "string",
#'   RecursiveDeleteOption = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_delete_work_group
athena_delete_work_group <- function(WorkGroup, RecursiveDeleteOption = NULL) {
  op <- new_operation(
    name = "DeleteWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_work_group_input(WorkGroup = WorkGroup, RecursiveDeleteOption = RecursiveDeleteOption)
  output <- .athena$delete_work_group_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_work_group <- athena_delete_work_group

#' Returns the specified data catalog
#'
#' Returns the specified data catalog.
#'
#' @usage
#' athena_get_data_catalog(Name)
#'
#' @param Name &#91;required&#93; The name of the data catalog to return.
#'
#' @section Request syntax:
#' ```
#' svc$get_data_catalog(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_get_data_catalog
athena_get_data_catalog <- function(Name) {
  op <- new_operation(
    name = "GetDataCatalog",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_data_catalog_input(Name = Name)
  output <- .athena$get_data_catalog_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_data_catalog <- athena_get_data_catalog

#' Returns a database object for the specfied database and data catalog
#'
#' Returns a database object for the specfied database and data catalog.
#'
#' @usage
#' athena_get_database(CatalogName, DatabaseName)
#'
#' @param CatalogName &#91;required&#93; The name of the data catalog that contains the database to return.
#' @param DatabaseName &#91;required&#93; The name of the database to return.
#'
#' @section Request syntax:
#' ```
#' svc$get_database(
#'   CatalogName = "string",
#'   DatabaseName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_get_database
athena_get_database <- function(CatalogName, DatabaseName) {
  op <- new_operation(
    name = "GetDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_database_input(CatalogName = CatalogName, DatabaseName = DatabaseName)
  output <- .athena$get_database_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_database <- athena_get_database

#' Returns information about a single query
#'
#' Returns information about a single query. Requires that you have access
#' to the workgroup in which the query was saved.
#'
#' @usage
#' athena_get_named_query(NamedQueryId)
#'
#' @param NamedQueryId &#91;required&#93; The unique ID of the query. Use ListNamedQueries to get query IDs.
#'
#' @section Request syntax:
#' ```
#' svc$get_named_query(
#'   NamedQueryId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_get_named_query
athena_get_named_query <- function(NamedQueryId) {
  op <- new_operation(
    name = "GetNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_named_query_input(NamedQueryId = NamedQueryId)
  output <- .athena$get_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_named_query <- athena_get_named_query

#' Returns information about a single execution of a query if you have
#' access to the workgroup in which the query ran
#'
#' Returns information about a single execution of a query if you have
#' access to the workgroup in which the query ran. Each time a query
#' executes, information about the query execution is saved with a unique
#' ID.
#'
#' @usage
#' athena_get_query_execution(QueryExecutionId)
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution.
#'
#' @section Request syntax:
#' ```
#' svc$get_query_execution(
#'   QueryExecutionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_get_query_execution
athena_get_query_execution <- function(QueryExecutionId) {
  op <- new_operation(
    name = "GetQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_query_execution_input(QueryExecutionId = QueryExecutionId)
  output <- .athena$get_query_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_query_execution <- athena_get_query_execution

#' Streams the results of a single query execution specified by
#' QueryExecutionId from the Athena query results location in Amazon S3
#'
#' Streams the results of a single query execution specified by
#' `QueryExecutionId` from the Athena query results location in Amazon S3.
#' For more information, see [Query
#' Results](https://docs.aws.amazon.com/athena/latest/ug/querying.html) in
#' the *Amazon Athena User Guide*. This request does not execute the query
#' but returns results. Use StartQueryExecution to run a query.
#' 
#' To stream query results successfully, the IAM principal with permission
#' to call `GetQueryResults` also must have permissions to the Amazon S3
#' `GetObject` action for the Athena query results location.
#' 
#' IAM principals with permission to the Amazon S3 `GetObject` action for
#' the query results location are able to retrieve query results from
#' Amazon S3 even if permission to the `GetQueryResults` action is denied.
#' To restrict user or role access, ensure that Amazon S3 permissions to
#' the Athena query location are denied.
#'
#' @usage
#' athena_get_query_results(QueryExecutionId, NextToken, MaxResults)
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of results (rows) to return in this request.
#'
#' @section Request syntax:
#' ```
#' svc$get_query_results(
#'   QueryExecutionId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_get_query_results
athena_get_query_results <- function(QueryExecutionId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetQueryResults",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_query_results_input(QueryExecutionId = QueryExecutionId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$get_query_results_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_query_results <- athena_get_query_results

#' Returns table metadata for the specified catalog, database, and table
#'
#' Returns table metadata for the specified catalog, database, and table.
#'
#' @usage
#' athena_get_table_metadata(CatalogName, DatabaseName, TableName)
#'
#' @param CatalogName &#91;required&#93; The name of the data catalog that contains the database and table
#' metadata to return.
#' @param DatabaseName &#91;required&#93; The name of the database that contains the table metadata to return.
#' @param TableName &#91;required&#93; The name of the table for which metadata is returned.
#'
#' @section Request syntax:
#' ```
#' svc$get_table_metadata(
#'   CatalogName = "string",
#'   DatabaseName = "string",
#'   TableName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_get_table_metadata
athena_get_table_metadata <- function(CatalogName, DatabaseName, TableName) {
  op <- new_operation(
    name = "GetTableMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_table_metadata_input(CatalogName = CatalogName, DatabaseName = DatabaseName, TableName = TableName)
  output <- .athena$get_table_metadata_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_table_metadata <- athena_get_table_metadata

#' Returns information about the workgroup with the specified name
#'
#' Returns information about the workgroup with the specified name.
#'
#' @usage
#' athena_get_work_group(WorkGroup)
#'
#' @param WorkGroup &#91;required&#93; The name of the workgroup.
#'
#' @section Request syntax:
#' ```
#' svc$get_work_group(
#'   WorkGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_get_work_group
athena_get_work_group <- function(WorkGroup) {
  op <- new_operation(
    name = "GetWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_work_group_input(WorkGroup = WorkGroup)
  output <- .athena$get_work_group_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_work_group <- athena_get_work_group

#' Lists the data catalogs in the current AWS account
#'
#' Lists the data catalogs in the current AWS account.
#'
#' @usage
#' athena_list_data_catalogs(NextToken, MaxResults)
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the NextToken from the response object of the previous
#' page call.
#' @param MaxResults Specifies the maximum number of data catalogs to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_data_catalogs(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_list_data_catalogs
athena_list_data_catalogs <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDataCatalogs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_data_catalogs_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_data_catalogs_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_data_catalogs <- athena_list_data_catalogs

#' Lists the databases in the specified data catalog
#'
#' Lists the databases in the specified data catalog.
#'
#' @usage
#' athena_list_databases(CatalogName, NextToken, MaxResults)
#'
#' @param CatalogName &#91;required&#93; The name of the data catalog that contains the databases to return.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults Specifies the maximum number of results to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_databases(
#'   CatalogName = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_list_databases
athena_list_databases <- function(CatalogName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDatabases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_databases_input(CatalogName = CatalogName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_databases_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_databases <- athena_list_databases

#' Provides a list of available query IDs only for queries saved in the
#' specified workgroup
#'
#' Provides a list of available query IDs only for queries saved in the
#' specified workgroup. Requires that you have access to the specified
#' workgroup. If a workgroup is not specified, lists the saved queries for
#' the primary workgroup.
#' 
#' For code samples using the AWS SDK for Java, see [Examples and Code
#' Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html)
#' in the *Amazon Athena User Guide*.
#'
#' @usage
#' athena_list_named_queries(NextToken, MaxResults, WorkGroup)
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of queries to return in this request.
#' @param WorkGroup The name of the workgroup from which the named queries are being
#' returned. If a workgroup is not specified, the saved queries for the
#' primary workgroup are returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_named_queries(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   WorkGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_list_named_queries
athena_list_named_queries <- function(NextToken = NULL, MaxResults = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "ListNamedQueries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_named_queries_input(NextToken = NextToken, MaxResults = MaxResults, WorkGroup = WorkGroup)
  output <- .athena$list_named_queries_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_named_queries <- athena_list_named_queries

#' Provides a list of available query execution IDs for the queries in the
#' specified workgroup
#'
#' Provides a list of available query execution IDs for the queries in the
#' specified workgroup. If a workgroup is not specified, returns a list of
#' query execution IDs for the primary workgroup. Requires you to have
#' access to the workgroup in which the queries ran.
#' 
#' For code samples using the AWS SDK for Java, see [Examples and Code
#' Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html)
#' in the *Amazon Athena User Guide*.
#'
#' @usage
#' athena_list_query_executions(NextToken, MaxResults, WorkGroup)
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of query executions to return in this request.
#' @param WorkGroup The name of the workgroup from which queries are being returned. If a
#' workgroup is not specified, a list of available query execution IDs for
#' the queries in the primary workgroup is returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_query_executions(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   WorkGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_list_query_executions
athena_list_query_executions <- function(NextToken = NULL, MaxResults = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "ListQueryExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_query_executions_input(NextToken = NextToken, MaxResults = MaxResults, WorkGroup = WorkGroup)
  output <- .athena$list_query_executions_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_query_executions <- athena_list_query_executions

#' Lists the metadata for the tables in the specified data catalog database
#'
#' Lists the metadata for the tables in the specified data catalog
#' database.
#'
#' @usage
#' athena_list_table_metadata(CatalogName, DatabaseName, Expression,
#'   NextToken, MaxResults)
#'
#' @param CatalogName &#91;required&#93; The name of the data catalog for which table metadata should be
#' returned.
#' @param DatabaseName &#91;required&#93; The name of the database for which table metadata should be returned.
#' @param Expression A regex filter that pattern-matches table names. If no expression is
#' supplied, metadata for all tables are listed.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the NextToken from the response object of the previous
#' page call.
#' @param MaxResults Specifies the maximum number of results to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_table_metadata(
#'   CatalogName = "string",
#'   DatabaseName = "string",
#'   Expression = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_list_table_metadata
athena_list_table_metadata <- function(CatalogName, DatabaseName, Expression = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTableMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_table_metadata_input(CatalogName = CatalogName, DatabaseName = DatabaseName, Expression = Expression, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_table_metadata_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_table_metadata <- athena_list_table_metadata

#' Lists the tags associated with an Athena workgroup or data catalog
#' resource
#'
#' Lists the tags associated with an Athena workgroup or data catalog
#' resource.
#'
#' @usage
#' athena_list_tags_for_resource(ResourceARN, NextToken, MaxResults)
#'
#' @param ResourceARN &#91;required&#93; Lists the tags for the resource with the specified ARN.
#' @param NextToken The token for the next set of results, or null if there are no
#' additional results for this request, where the request lists the tags
#' for the resource with the specified ARN.
#' @param MaxResults The maximum number of results to be returned per request that lists the
#' tags for the resource.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_list_tags_for_resource
athena_list_tags_for_resource <- function(ResourceARN, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_tags_for_resource_input(ResourceARN = ResourceARN, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_tags_for_resource_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_tags_for_resource <- athena_list_tags_for_resource

#' Lists available workgroups for the account
#'
#' Lists available workgroups for the account.
#'
#' @usage
#' athena_list_work_groups(NextToken, MaxResults)
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of workgroups to return in this request.
#'
#' @section Request syntax:
#' ```
#' svc$list_work_groups(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_list_work_groups
athena_list_work_groups <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_work_groups_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_work_groups_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_work_groups <- athena_list_work_groups

#' Runs the SQL query statements contained in the Query
#'
#' Runs the SQL query statements contained in the `Query`. Requires you to
#' have access to the workgroup in which the query ran. Running queries
#' against an external catalog requires GetDataCatalog permission to the
#' catalog. For code samples using the AWS SDK for Java, see [Examples and
#' Code
#' Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html)
#' in the *Amazon Athena User Guide*.
#'
#' @usage
#' athena_start_query_execution(QueryString, ClientRequestToken,
#'   QueryExecutionContext, ResultConfiguration, WorkGroup)
#'
#' @param QueryString &#91;required&#93; The SQL query statements to be executed.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to create the
#' query is idempotent (executes only once). If another
#' `StartQueryExecution` request is received, the same response is returned
#' and another query is not created. If a parameter has changed, for
#' example, the `QueryString`, an error is returned.
#' 
#' This token is listed as not required because AWS SDKs (for example the
#' AWS SDK for Java) auto-generate the token for users. If you are not
#' using the AWS SDK or the AWS CLI, you must provide this token or the
#' action will fail.
#' @param QueryExecutionContext The database within which the query executes.
#' @param ResultConfiguration Specifies information about where and how to save the results of the
#' query execution. If the query runs in a workgroup, then workgroup\'s
#' settings may override query settings. This affects the query results
#' location. The workgroup settings override is specified in
#' EnforceWorkGroupConfiguration (true/false) in the
#' WorkGroupConfiguration. See
#' WorkGroupConfiguration\\$EnforceWorkGroupConfiguration.
#' @param WorkGroup The name of the workgroup in which the query is being started.
#'
#' @section Request syntax:
#' ```
#' svc$start_query_execution(
#'   QueryString = "string",
#'   ClientRequestToken = "string",
#'   QueryExecutionContext = list(
#'     Database = "string",
#'     Catalog = "string"
#'   ),
#'   ResultConfiguration = list(
#'     OutputLocation = "string",
#'     EncryptionConfiguration = list(
#'       EncryptionOption = "SSE_S3"|"SSE_KMS"|"CSE_KMS",
#'       KmsKey = "string"
#'     )
#'   ),
#'   WorkGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_start_query_execution
athena_start_query_execution <- function(QueryString, ClientRequestToken = NULL, QueryExecutionContext = NULL, ResultConfiguration = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "StartQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$start_query_execution_input(QueryString = QueryString, ClientRequestToken = ClientRequestToken, QueryExecutionContext = QueryExecutionContext, ResultConfiguration = ResultConfiguration, WorkGroup = WorkGroup)
  output <- .athena$start_query_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$start_query_execution <- athena_start_query_execution

#' Stops a query execution
#'
#' Stops a query execution. Requires you to have access to the workgroup in
#' which the query ran.
#' 
#' For code samples using the AWS SDK for Java, see [Examples and Code
#' Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html)
#' in the *Amazon Athena User Guide*.
#'
#' @usage
#' athena_stop_query_execution(QueryExecutionId)
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_query_execution(
#'   QueryExecutionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_stop_query_execution
athena_stop_query_execution <- function(QueryExecutionId) {
  op <- new_operation(
    name = "StopQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$stop_query_execution_input(QueryExecutionId = QueryExecutionId)
  output <- .athena$stop_query_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$stop_query_execution <- athena_stop_query_execution

#' Adds one or more tags to an Athena resource
#'
#' Adds one or more tags to an Athena resource. A tag is a label that you
#' assign to a resource. In Athena, a resource can be a workgroup or data
#' catalog. Each tag consists of a key and an optional value, both of which
#' you define. For example, you can use tags to categorize Athena
#' workgroups or data catalogs by purpose, owner, or environment. Use a
#' consistent set of tag keys to make it easier to search and filter
#' workgroups or data catalogs in your account. For best practices, see
#' [Tagging Best
#' Practices](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
#' Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values
#' can be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and
#' numbers representable in UTF-8, and the following characters: + - = . \\_
#' : / @@. Tag keys and values are case-sensitive. Tag keys must be unique
#' per resource. If you specify more than one tag, separate them by commas.
#'
#' @usage
#' athena_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; Specifies the ARN of the Athena resource (workgroup or data catalog) to
#' which tags are to be added.
#' @param Tags &#91;required&#93; A collection of one or more tags, separated by commas, to be added to an
#' Athena workgroup or data catalog resource.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_tag_resource
athena_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .athena$tag_resource_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$tag_resource <- athena_tag_resource

#' Removes one or more tags from a data catalog or workgroup resource
#'
#' Removes one or more tags from a data catalog or workgroup resource.
#'
#' @usage
#' athena_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; Specifies the ARN of the resource from which tags are to be removed.
#' @param TagKeys &#91;required&#93; A comma-separated list of one or more tag keys whose tags are to be
#' removed from the specified resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_untag_resource
athena_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .athena$untag_resource_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$untag_resource <- athena_untag_resource

#' Updates the data catalog that has the specified name
#'
#' Updates the data catalog that has the specified name.
#'
#' @usage
#' athena_update_data_catalog(Name, Type, Description, Parameters)
#'
#' @param Name &#91;required&#93; The name of the data catalog to update. The catalog name must be unique
#' for the AWS account and can use a maximum of 128 alphanumeric,
#' underscore, at sign, or hyphen characters.
#' @param Type &#91;required&#93; Specifies the type of data catalog to update. Specify `LAMBDA` for a
#' federated catalog, `GLUE` for AWS Glue Catalog, or `HIVE` for an
#' external hive metastore.
#' @param Description New or modified text that describes the data catalog.
#' @param Parameters Specifies the Lambda function or functions to use for updating the data
#' catalog. This is a mapping whose values depend on the catalog type.
#' 
#' -   For the `HIVE` data catalog type, use the following syntax. The
#'     `metadata-function` parameter is required. `The sdk-version`
#'     parameter is optional and defaults to the currently supported
#'     version.
#' 
#'     `metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> `
#' 
#' -   For the `LAMBDA` data catalog type, use one of the following sets of
#'     required parameters, but not both.
#' 
#'     -   If you have one Lambda function that processes metadata and
#'         another for reading the actual data, use the following syntax.
#'         Both parameters are required.
#' 
#'         `metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> `
#' 
#'     -   If you have a composite Lambda function that processes both
#'         metadata and data, use the following syntax to specify your
#'         Lambda function.
#' 
#'         `function=<i>lambda_arn</i> `
#' 
#' -   The `GLUE` type has no parameters.
#'
#' @section Request syntax:
#' ```
#' svc$update_data_catalog(
#'   Name = "string",
#'   Type = "LAMBDA"|"GLUE"|"HIVE",
#'   Description = "string",
#'   Parameters = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_update_data_catalog
athena_update_data_catalog <- function(Name, Type, Description = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "UpdateDataCatalog",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_data_catalog_input(Name = Name, Type = Type, Description = Description, Parameters = Parameters)
  output <- .athena$update_data_catalog_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_data_catalog <- athena_update_data_catalog

#' Updates the workgroup with the specified name
#'
#' Updates the workgroup with the specified name. The workgroup\'s name
#' cannot be changed.
#'
#' @usage
#' athena_update_work_group(WorkGroup, Description, ConfigurationUpdates,
#'   State)
#'
#' @param WorkGroup &#91;required&#93; The specified workgroup that will be updated.
#' @param Description The workgroup description.
#' @param ConfigurationUpdates The workgroup configuration that will be updated for the given
#' workgroup.
#' @param State The workgroup state that will be updated for the given workgroup.
#'
#' @section Request syntax:
#' ```
#' svc$update_work_group(
#'   WorkGroup = "string",
#'   Description = "string",
#'   ConfigurationUpdates = list(
#'     EnforceWorkGroupConfiguration = TRUE|FALSE,
#'     ResultConfigurationUpdates = list(
#'       OutputLocation = "string",
#'       RemoveOutputLocation = TRUE|FALSE,
#'       EncryptionConfiguration = list(
#'         EncryptionOption = "SSE_S3"|"SSE_KMS"|"CSE_KMS",
#'         KmsKey = "string"
#'       ),
#'       RemoveEncryptionConfiguration = TRUE|FALSE
#'     ),
#'     PublishCloudWatchMetricsEnabled = TRUE|FALSE,
#'     BytesScannedCutoffPerQuery = 123,
#'     RemoveBytesScannedCutoffPerQuery = TRUE|FALSE,
#'     RequesterPaysEnabled = TRUE|FALSE
#'   ),
#'   State = "ENABLED"|"DISABLED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_update_work_group
athena_update_work_group <- function(WorkGroup, Description = NULL, ConfigurationUpdates = NULL, State = NULL) {
  op <- new_operation(
    name = "UpdateWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_work_group_input(WorkGroup = WorkGroup, Description = Description, ConfigurationUpdates = ConfigurationUpdates, State = State)
  output <- .athena$update_work_group_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_work_group <- athena_update_work_group
