% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_data_set}
\alias{quicksight_update_data_set}
\title{Updates a dataset}
\usage{
quicksight_update_data_set(AwsAccountId, DataSetId, Name,
  PhysicalTableMap, LogicalTableMap, ImportMode, ColumnGroups,
  RowLevelPermissionDataSet)
}
\arguments{
\item{AwsAccountId}{[required] The AWS account ID.}

\item{DataSetId}{[required] The ID for the dataset that you want to update. This ID is unique per
AWS Region for each AWS account.}

\item{Name}{[required] The display name for the dataset.}

\item{PhysicalTableMap}{[required] Declares the physical tables that are available in the underlying data
sources.}

\item{LogicalTableMap}{Configures the combination and transformation of the data from the
physical tables.}

\item{ImportMode}{[required] Indicates whether you want to import the data into SPICE.}

\item{ColumnGroups}{Groupings of columns that work together in certain QuickSight features.
Currently, only geospatial hierarchy is supported.}

\item{RowLevelPermissionDataSet}{The row-level security configuration for the data you want to create.}
}
\description{
Updates a dataset.
}
\section{Request syntax}{
\preformatted{svc$update_data_set(
  AwsAccountId = "string",
  DataSetId = "string",
  Name = "string",
  PhysicalTableMap = list(
    list(
      RelationalTable = list(
        DataSourceArn = "string",
        Schema = "string",
        Name = "string",
        InputColumns = list(
          list(
            Name = "string",
            Type = "STRING"|"INTEGER"|"DECIMAL"|"DATETIME"|"BIT"|"BOOLEAN"|"JSON"
          )
        )
      ),
      CustomSql = list(
        DataSourceArn = "string",
        Name = "string",
        SqlQuery = "string",
        Columns = list(
          list(
            Name = "string",
            Type = "STRING"|"INTEGER"|"DECIMAL"|"DATETIME"|"BIT"|"BOOLEAN"|"JSON"
          )
        )
      ),
      S3Source = list(
        DataSourceArn = "string",
        UploadSettings = list(
          Format = "CSV"|"TSV"|"CLF"|"ELF"|"XLSX"|"JSON",
          StartFromRow = 123,
          ContainsHeader = TRUE|FALSE,
          TextQualifier = "DOUBLE_QUOTE"|"SINGLE_QUOTE",
          Delimiter = "string"
        ),
        InputColumns = list(
          list(
            Name = "string",
            Type = "STRING"|"INTEGER"|"DECIMAL"|"DATETIME"|"BIT"|"BOOLEAN"|"JSON"
          )
        )
      )
    )
  ),
  LogicalTableMap = list(
    list(
      Alias = "string",
      DataTransforms = list(
        list(
          ProjectOperation = list(
            ProjectedColumns = list(
              "string"
            )
          ),
          FilterOperation = list(
            ConditionExpression = "string"
          ),
          CreateColumnsOperation = list(
            Columns = list(
              list(
                ColumnName = "string",
                ColumnId = "string",
                Expression = "string"
              )
            )
          ),
          RenameColumnOperation = list(
            ColumnName = "string",
            NewColumnName = "string"
          ),
          CastColumnTypeOperation = list(
            ColumnName = "string",
            NewColumnType = "STRING"|"INTEGER"|"DECIMAL"|"DATETIME",
            Format = "string"
          ),
          TagColumnOperation = list(
            ColumnName = "string",
            Tags = list(
              list(
                ColumnGeographicRole = "COUNTRY"|"STATE"|"COUNTY"|"CITY"|"POSTCODE"|"LONGITUDE"|"LATITUDE"
              )
            )
          )
        )
      ),
      Source = list(
        JoinInstruction = list(
          LeftOperand = "string",
          RightOperand = "string",
          Type = "INNER"|"OUTER"|"LEFT"|"RIGHT",
          OnClause = "string"
        ),
        PhysicalTableId = "string"
      )
    )
  ),
  ImportMode = "SPICE"|"DIRECT_QUERY",
  ColumnGroups = list(
    list(
      GeoSpatialColumnGroup = list(
        Name = "string",
        CountryCode = "US",
        Columns = list(
          "string"
        )
      )
    )
  ),
  RowLevelPermissionDataSet = list(
    Arn = "string",
    PermissionPolicy = "GRANT_ACCESS"|"DENY_ACCESS"
  )
)
}
}

\keyword{internal}
