% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_update_crawler}
\alias{glue_update_crawler}
\title{Updates a crawler}
\usage{
glue_update_crawler(
  Name,
  Role = NULL,
  DatabaseName = NULL,
  Description = NULL,
  Targets = NULL,
  Schedule = NULL,
  Classifiers = NULL,
  TablePrefix = NULL,
  SchemaChangePolicy = NULL,
  RecrawlPolicy = NULL,
  LineageConfiguration = NULL,
  LakeFormationConfiguration = NULL,
  Configuration = NULL,
  CrawlerSecurityConfiguration = NULL
)
}
\arguments{
\item{Name}{[required] Name of the new crawler.}

\item{Role}{The IAM role or Amazon Resource Name (ARN) of an IAM role that is used
by the new crawler to access customer resources.}

\item{DatabaseName}{The Glue database where results are stored, such as:
\verb{arn:aws:daylight:us-east-1::database/sometable/*}.}

\item{Description}{A description of the new crawler.}

\item{Targets}{A list of targets to crawl.}

\item{Schedule}{A \code{cron} expression used to specify the schedule (see \href{https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html}{Time-Based Schedules for Jobs and Crawlers}.
For example, to run something every day at 12:15 UTC, you would specify:
\verb{cron(15 12 * * ? *)}.}

\item{Classifiers}{A list of custom classifiers that the user has registered. By default,
all built-in classifiers are included in a crawl, but these custom
classifiers always override the default classifiers for a given
classification.}

\item{TablePrefix}{The table prefix used for catalog tables that are created.}

\item{SchemaChangePolicy}{The policy for the crawler's update and deletion behavior.}

\item{RecrawlPolicy}{A policy that specifies whether to crawl the entire dataset again, or to
crawl only folders that were added since the last crawler run.}

\item{LineageConfiguration}{Specifies data lineage configuration settings for the crawler.}

\item{LakeFormationConfiguration}{Specifies Lake Formation configuration settings for the crawler.}

\item{Configuration}{Crawler configuration information. This versioned JSON string allows
users to specify aspects of a crawler's behavior. For more information,
see \href{https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html}{Configuring a Crawler}.}

\item{CrawlerSecurityConfiguration}{The name of the \code{SecurityConfiguration} structure to be used by this
crawler.}
}
\description{
Updates a crawler. If a crawler is running, you must stop it using \code{\link[=glue_stop_crawler]{stop_crawler}} before updating it.

See \url{https://paws-r.github.io/docs/glue/update_crawler.html} for full documentation.
}
\keyword{internal}
