% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gluedatabrew_operations.R
\name{gluedatabrew_send_project_session_action}
\alias{gluedatabrew_send_project_session_action}
\title{Performs a recipe step within an interactive DataBrew session that's
currently open}
\usage{
gluedatabrew_send_project_session_action(
  Preview = NULL,
  Name,
  RecipeStep = NULL,
  StepIndex = NULL,
  ClientSessionId = NULL,
  ViewFrame = NULL
)
}
\arguments{
\item{Preview}{If true, the result of the recipe step will be returned, but not
applied.}

\item{Name}{[required] The name of the project to apply the action to.}

\item{RecipeStep}{}

\item{StepIndex}{The index from which to preview a step. This index is used to preview
the result of steps that have already been applied, so that the
resulting view frame is from earlier in the view frame stack.}

\item{ClientSessionId}{A unique identifier for an interactive session that's currently open and
ready for work. The action will be performed on this session.}

\item{ViewFrame}{}
}
\description{
Performs a recipe step within an interactive DataBrew session that's currently open.

See \url{https://paws-r.github.io/docs/gluedatabrew/send_project_session_action.html} for full documentation.
}
\keyword{internal}
