% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivs_operations.R
\name{ivs_create_channel}
\alias{ivs_create_channel}
\title{Creates a new channel and an associated stream key to start streaming}
\usage{
ivs_create_channel(
  authorized = NULL,
  latencyMode = NULL,
  name = NULL,
  recordingConfigurationArn = NULL,
  tags = NULL,
  type = NULL
)
}
\arguments{
\item{authorized}{Whether the channel is private (enabled for playback authorization).
Default: \code{false}.}

\item{latencyMode}{Channel latency mode. Use \code{NORMAL} to broadcast and deliver live video
up to Full HD. Use \code{LOW} for near-real-time interaction with viewers.
(Note: In the Amazon IVS console, \code{LOW} and \code{NORMAL} correspond to
Ultra-low and Standard, respectively.) Default: \code{LOW}.}

\item{name}{Channel name.}

\item{recordingConfigurationArn}{Recording-configuration ARN. Default: "" (empty string, recording is
disabled).}

\item{tags}{Array of 1-50 maps, each of the form \code{string:string (key:value)}.}

\item{type}{Channel type, which determines the allowable resolution and bitrate. \emph{If
you exceed the allowable resolution or bitrate, the stream probably will
disconnect immediately.} Default: \code{STANDARD}. Valid values:
\itemize{
\item \code{STANDARD}: Multiple qualities are generated from the original
input, to automatically give viewers the best experience for their
devices and network conditions. Resolution can be up to 1080p and
bitrate can be up to 8.5 Mbps. Audio is transcoded only for
renditions 360p and below; above that, audio is passed through.
\item \code{BASIC}: Amazon IVS delivers the original input to viewers. The
viewer’s video-quality choice is limited to the original input.
Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.
}}
}
\description{
Creates a new channel and an associated stream key to start streaming.

See \url{https://paws-r.github.io/docs/ivs/create_channel.html} for full documentation.
}
\keyword{internal}
