% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_update_notebook}
\alias{athena_update_notebook}
\title{Updates the contents of a Spark notebook}
\usage{
athena_update_notebook(
  NotebookId,
  Payload,
  Type,
  SessionId = NULL,
  ClientRequestToken = NULL
)
}
\arguments{
\item{NotebookId}{[required] The ID of the notebook to update.}

\item{Payload}{[required] The updated content for the notebook.}

\item{Type}{[required] The notebook content type. Currently, the only valid type is \code{IPYNB}.}

\item{SessionId}{The active notebook session ID. Required if the notebook has an active
session.}

\item{ClientRequestToken}{A unique case-sensitive string used to ensure the request to create the
notebook is idempotent (executes only once).

This token is listed as not required because Amazon Web Services SDKs
(for example the Amazon Web Services SDK for Java) auto-generate the
token for you. If you are not using the Amazon Web Services SDK or the
Amazon Web Services CLI, you must provide this token or the action will
fail.}
}
\description{
Updates the contents of a Spark notebook.

See \url{https://www.paws-r-sdk.com/docs/athena_update_notebook/} for full documentation.
}
\keyword{internal}
