% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_respond_activity_task_failed}
\alias{swf_respond_activity_task_failed}
\title{Used by workers to tell the service that the ActivityTask identified by
the taskToken has failed with reason (if specified)}
\usage{
swf_respond_activity_task_failed(taskToken, reason = NULL, details = NULL)
}
\arguments{
\item{taskToken}{[required] The \code{taskToken} of the ActivityTask.

\code{taskToken} is generated by the service and should be treated as an
opaque value. If the task is passed to another process, its \code{taskToken}
must also be passed. This enables it to provide its progress and respond
with results.}

\item{reason}{Description of the error that may assist in diagnostics.}

\item{details}{Detailed information about the failure.}
}
\description{
Used by workers to tell the service that the ActivityTask identified by the \code{taskToken} has failed with \code{reason} (if specified). The \code{reason} and \code{details} appear in the \code{ActivityTaskFailed} event added to the workflow history.

See \url{https://paws-r.github.io/docs/swf/respond_activity_task_failed.html} for full documentation.
}
\keyword{internal}
