% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_start_workflow_execution}
\alias{swf_start_workflow_execution}
\title{Starts an execution of the workflow type in the specified domain using
the provided workflowId and input data}
\usage{
swf_start_workflow_execution(
  domain,
  workflowId,
  workflowType,
  taskList = NULL,
  taskPriority = NULL,
  input = NULL,
  executionStartToCloseTimeout = NULL,
  tagList = NULL,
  taskStartToCloseTimeout = NULL,
  childPolicy = NULL,
  lambdaRole = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain in which the workflow execution is created.}

\item{workflowId}{[required] The user defined identifier associated with the workflow execution. You
can use this to associate a custom identifier with the workflow
execution. You may specify the same identifier if a workflow execution
is logically a \emph{restart} of a previous execution. You cannot have two
open workflow executions with the same \code{workflowId} at the same time
within the same domain.

The specified string must not start or end with whitespace. It must not
contain a \code{:} (colon), \code{/} (slash), \code{|} (vertical bar), or any control
characters (\verb{U+0000`-`U+001f} | \verb{U+007f`-`U+009f}). Also, it must not \emph{be}
the literal string \code{arn}.}

\item{workflowType}{[required] The type of the workflow to start.}

\item{taskList}{The task list to use for the decision tasks generated for this workflow
execution. This overrides the \code{defaultTaskList} specified when
registering the workflow type.

A task list for this workflow execution must be specified either as a
default for the workflow type or through this parameter. If neither this
parameter is set nor a default task list was specified at registration
time then a fault is returned.

The specified string must not start or end with whitespace. It must not
contain a \code{:} (colon), \code{/} (slash), \code{|} (vertical bar), or any control
characters (\verb{U+0000`-`U+001f} | \verb{U+007f`-`U+009f}). Also, it must not \emph{be}
the literal string \code{arn}.}

\item{taskPriority}{The task priority to use for this workflow execution. This overrides any
default priority that was assigned when the workflow type was
registered. If not set, then the default task priority for the workflow
type is used. Valid values are integers that range from Java's
\code{Integer.MIN_VALUE} (-2147483648) to \code{Integer.MAX_VALUE} (2147483647).
Higher numbers indicate higher priority.

For more information about setting task priority, see \href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html}{Setting Task Priority}
in the \emph{Amazon SWF Developer Guide}.}

\item{input}{The input for the workflow execution. This is a free form string which
should be meaningful to the workflow you are starting. This \code{input} is
made available to the new workflow execution in the
\code{WorkflowExecutionStarted} history event.}

\item{executionStartToCloseTimeout}{The total duration for this workflow execution. This overrides the
defaultExecutionStartToCloseTimeout specified when registering the
workflow type.

The duration is specified in seconds; an integer greater than or equal
to \code{0}. Exceeding this limit causes the workflow execution to time out.
Unlike some of the other timeout parameters in Amazon SWF, you cannot
specify a value of "NONE" for this timeout; there is a one-year max
limit on the time that a workflow execution can run.

An execution start-to-close timeout must be specified either through
this parameter or as a default when the workflow type is registered. If
neither this parameter nor a default execution start-to-close timeout is
specified, a fault is returned.}

\item{tagList}{The list of tags to associate with the workflow execution. You can
specify a maximum of 5 tags. You can list workflow executions with a
specific tag by calling
\code{\link[=swf_list_open_workflow_executions]{list_open_workflow_executions}} or
\code{\link[=swf_list_closed_workflow_executions]{list_closed_workflow_executions}}
and specifying a TagFilter.}

\item{taskStartToCloseTimeout}{Specifies the maximum duration of decision tasks for this workflow
execution. This parameter overrides the \code{defaultTaskStartToCloseTimout}
specified when registering the workflow type using
\code{\link[=swf_register_workflow_type]{register_workflow_type}}.

The duration is specified in seconds, an integer greater than or equal
to \code{0}. You can use \code{NONE} to specify unlimited duration.

A task start-to-close timeout for this workflow execution must be
specified either as a default for the workflow type or through this
parameter. If neither this parameter is set nor a default task
start-to-close timeout was specified at registration time then a fault
is returned.}

\item{childPolicy}{If set, specifies the policy to use for the child workflow executions of
this workflow execution if it is terminated, by calling the
\code{\link[=swf_terminate_workflow_execution]{terminate_workflow_execution}}
action explicitly or due to an expired timeout. This policy overrides
the default child policy specified when registering the workflow type
using \code{\link[=swf_register_workflow_type]{register_workflow_type}}.

The supported child policies are:
\itemize{
\item \code{TERMINATE} – The child executions are terminated.
\item \code{REQUEST_CANCEL} – A request to cancel is attempted for each child
execution by recording a \code{WorkflowExecutionCancelRequested} event in
its history. It is up to the decider to take appropriate actions
when it receives an execution history with this event.
\item \code{ABANDON} – No action is taken. The child executions continue to
run.
}

A child policy for this workflow execution must be specified either as a
default for the workflow type or through this parameter. If neither this
parameter is set nor a default child policy was specified at
registration time then a fault is returned.}

\item{lambdaRole}{The IAM role to attach to this workflow execution.

Executions of this workflow type need IAM roles to invoke Lambda
functions. If you don't attach an IAM role, any attempt to schedule a
Lambda task fails. This results in a \code{ScheduleLambdaFunctionFailed}
history event. For more information, see
\url{https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html}
in the \emph{Amazon SWF Developer Guide}.}
}
\description{
Starts an execution of the workflow type in the specified domain using the provided \code{workflowId} and input data.

See \url{https://paws-r.github.io/docs/swf/start_workflow_execution.html} for full documentation.
}
\keyword{internal}
