% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_enable_vgw_route_propagation}
\alias{ec2_enable_vgw_route_propagation}
\title{Enables a virtual private gateway (VGW) to propagate routes to the
specified route table of a VPC}
\usage{
ec2_enable_vgw_route_propagation(GatewayId, RouteTableId)
}
\arguments{
\item{GatewayId}{[required] The ID of the virtual private gateway.}

\item{RouteTableId}{[required] The ID of the route table.}
}
\description{
Enables a virtual private gateway (VGW) to propagate routes to the
specified route table of a VPC.
}
\section{Request syntax}{
\preformatted{svc$enable_vgw_route_propagation(
  GatewayId = "string",
  RouteTableId = "string"
)
}
}

\examples{
# This example enables the specified virtual private gateway to propagate
# static routes to the specified route table.
\donttest{svc$enable_vgw_route_propagation(
  GatewayId = "vgw-9a4cacf3",
  RouteTableId = "rtb-22574640"
)}

}
\keyword{internal}
