% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_instance_metric_data}
\alias{lightsail_get_instance_metric_data}
\title{Returns the data points for the specified Amazon Lightsail instance
metric, given an instance name}
\usage{
lightsail_get_instance_metric_data(instanceName, metricName, period,
  startTime, endTime, unit, statistics)
}
\arguments{
\item{instanceName}{[required] The name of the instance for which you want to get metrics data.}

\item{metricName}{[required] The metric name to get data about.}

\item{period}{[required] The granularity, in seconds, of the returned data points.}

\item{startTime}{[required] The start time of the time period.}

\item{endTime}{[required] The end time of the time period.}

\item{unit}{[required] The unit. The list of valid values is below.}

\item{statistics}{[required] The instance statistics.}
}
\description{
Returns the data points for the specified Amazon Lightsail instance
metric, given an instance name.
}
\section{Request syntax}{
\preformatted{svc$get_instance_metric_data(
  instanceName = "string",
  metricName = "CPUUtilization"|"NetworkIn"|"NetworkOut"|"StatusCheckFailed"|"StatusCheckFailed_Instance"|"StatusCheckFailed_System",
  period = 123,
  startTime = as.POSIXct(
    "2015-01-01"
  ),
  endTime = as.POSIXct(
    "2015-01-01"
  ),
  unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
  statistics = list(
    "Minimum"|"Maximum"|"Sum"|"Average"|"SampleCount"
  )
)
}
}

\keyword{internal}
