# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS EC2 Instance Connect
#'
#' @description
#' AWS EC2 Connect Service is a service that enables system administrators
#' to publish temporary SSH keys to their EC2 instances in order to
#' establish connections to their instances without leaving a permanent
#' authentication option.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- ec2instanceconnect(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- ec2instanceconnect()
#' # The following example pushes a sample SSH public key to the EC2 instance
#' # i-abcd1234 in AZ us-west-2b for use by the instance OS user ec2-user.
#' svc$send_ssh_public_key(
#'   AvailabilityZone = "us-west-2a",
#'   InstanceId = "i-abcd1234",
#'   InstanceOSUser = "ec2-user",
#'   SSHPublicKey = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC3FlHqj2eqCdrGHuA6d..."
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=ec2instanceconnect_send_ssh_public_key]{send_ssh_public_key} \tab Pushes an SSH public key to a particular OS user on a given EC2 instance for 60 seconds
#' }
#'
#' @rdname ec2instanceconnect
#' @export
ec2instanceconnect <- function(config = list()) {
  svc <- .ec2instanceconnect$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.ec2instanceconnect <- list()

.ec2instanceconnect$operations <- list()

.ec2instanceconnect$metadata <- list(
  service_name = "ec2instanceconnect",
  endpoints = list("*" = list(endpoint = "ec2-instance-connect.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "ec2-instance-connect.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "ec2-instance-connect.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "ec2-instance-connect.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "EC2 Instance Connect",
  api_version = "2018-04-02",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "AWSEC2InstanceConnectService"
)

.ec2instanceconnect$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.ec2instanceconnect$metadata, handlers, config)
}
