% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_coip_pool_usage}
\alias{ec2_get_coip_pool_usage}
\title{Describes the allocations from the specified customer-owned address pool}
\usage{
ec2_get_coip_pool_usage(PoolId, Filters, MaxResults, NextToken, DryRun)
}
\arguments{
\item{PoolId}{[required] The ID of the address pool.}

\item{Filters}{The filters. The following are the possible values:
\itemize{
\item \code{coip-address-usage.allocation-id}
\item \code{coip-address-usage.aws-account-id}
\item \code{coip-address-usage.aws-service}
\item \code{coip-address-usage.co-ip}
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  CoipPoolId = "string",
  CoipAddressUsages = list(
    list(
      AllocationId = "string",
      AwsAccountId = "string",
      AwsService = "string",
      CoIp = "string"
    )
  ),
  LocalGatewayRouteTableId = "string"
)
}
}
\description{
Describes the allocations from the specified customer-owned address
pool.
}
\section{Request syntax}{
\preformatted{svc$get_coip_pool_usage(
  PoolId = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
