% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_instance_credit_specifications}
\alias{ec2_describe_instance_credit_specifications}
\title{Describes the credit option for CPU usage of the specified T2 or T3
instances}
\usage{
ec2_describe_instance_credit_specifications(DryRun, Filters,
  InstanceIds, MaxResults, NextToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{The filters.
\itemize{
\item \code{instance-id} - The ID of the instance.
}}

\item{InstanceIds}{The instance IDs.

Default: Describes all your instances.

Constraints: Maximum 1000 explicitly specified instance IDs.}

\item{MaxResults}{The maximum number of results to return in a single call. To retrieve
the remaining results, make another call with the returned \code{NextToken}
value. This value can be between 5 and 1000. You cannot specify this
parameter and the instance IDs parameter in the same call.}

\item{NextToken}{The token to retrieve the next page of results.}
}
\description{
Describes the credit option for CPU usage of the specified T2 or T3
instances. The credit options are \code{standard} and \code{unlimited}.
}
\details{
If you do not specify an instance ID, Amazon EC2 returns T2 and T3
instances with the \code{unlimited} credit option, as well as instances that
were previously configured as T2 or T3 with the \code{unlimited} credit
option. For example, if you resize a T2 instance, while it is configured
as \code{unlimited}, to an M4 instance, Amazon EC2 returns the M4 instance.

If you specify one or more instance IDs, Amazon EC2 returns the credit
option (\code{standard} or \code{unlimited}) of those instances. If you specify an
instance ID that is not valid, such as an instance that is not a T2 or
T3 instance, an error is returned.

Recently terminated instances might appear in the returned results. This
interval is usually less than one hour.

If an Availability Zone is experiencing a service disruption and you
specify instance IDs in the affected zone, or do not specify any
instance IDs at all, the call fails. If you specify only instance IDs in
an unaffected zone, the call works normally.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html}{Burstable Performance Instances}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_instance_credit_specifications(
  DryRun = TRUE|FALSE,
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  InstanceIds = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
