% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_get_repository_policy}
\alias{ecr_get_repository_policy}
\title{Retrieves the repository policy for a specified repository}
\usage{
ecr_get_repository_policy(registryId, repositoryName)
}
\arguments{
\item{registryId}{The AWS account ID associated with the registry that contains the
repository. If you do not specify a registry, the default registry is
assumed.}

\item{repositoryName}{[required] The name of the repository with the policy to retrieve.}
}
\description{
Retrieves the repository policy for a specified repository.
}
\section{Request syntax}{
\preformatted{svc$get_repository_policy(
  registryId = "string",
  repositoryName = "string"
)
}
}

\examples{
# This example obtains the repository policy for the repository named
# ubuntu.
\donttest{svc$get_repository_policy(
  repositoryName = "ubuntu"
)}

}
\keyword{internal}
