% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_accept_vpc_peering_connection}
\alias{ec2_accept_vpc_peering_connection}
\title{Accept a VPC peering connection request}
\usage{
ec2_accept_vpc_peering_connection(DryRun, VpcPeeringConnectionId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcPeeringConnectionId}{The ID of the VPC peering connection. You must specify this parameter in
the request.}
}
\description{
Accept a VPC peering connection request. To accept a request, the VPC
peering connection must be in the \code{pending-acceptance} state, and you
must be the owner of the peer VPC. Use DescribeVpcPeeringConnections to
view your outstanding VPC peering connection requests.
}
\details{
For an inter-Region VPC peering connection request, you must accept the
VPC peering connection in the Region of the accepter VPC.
}
\section{Request syntax}{
\preformatted{svc$accept_vpc_peering_connection(
  DryRun = TRUE|FALSE,
  VpcPeeringConnectionId = "string"
)
}
}

\keyword{internal}
