% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpc_attribute}
\alias{ec2_describe_vpc_attribute}
\title{Describes the specified attribute of the specified VPC}
\usage{
ec2_describe_vpc_attribute(Attribute, VpcId, DryRun)
}
\arguments{
\item{Attribute}{[required] The VPC attribute.}

\item{VpcId}{[required] The ID of the VPC.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the specified attribute of the specified VPC. You can specify
only one attribute at a time.
}
\section{Request syntax}{
\preformatted{svc$describe_vpc_attribute(
  Attribute = "enableDnsSupport"|"enableDnsHostnames",
  VpcId = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example describes the enableDnsSupport attribute. This attribute
# indicates whether DNS resolution is enabled for the VPC. If this
# attribute is true, the Amazon DNS server resolves DNS hostnames for your
# instances to their corresponding IP addresses; otherwise, it does not.
svc$describe_vpc_attribute(
  Attribute = "enableDnsSupport",
  VpcId = "vpc-a01106c2"
)

# This example describes the enableDnsHostnames attribute. This attribute
# indicates whether the instances launched in the VPC get DNS hostnames.
# If this attribute is true, instances in the VPC get DNS hostnames;
# otherwise, they do not.
svc$describe_vpc_attribute(
  Attribute = "enableDnsHostnames",
  VpcId = "vpc-a01106c2"
)
}

}
\keyword{internal}
