% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_detach_volume}
\alias{ec2_detach_volume}
\title{Detaches an EBS volume from an instance}
\usage{
ec2_detach_volume(Device, Force, InstanceId, VolumeId, DryRun)
}
\arguments{
\item{Device}{The device name.}

\item{Force}{Forces detachment if the previous detachment attempt did not occur
cleanly (for example, logging into an instance, unmounting the volume,
and detaching normally). This option can lead to data loss or a
corrupted file system. Use this option only as a last resort to detach a
volume from a failed instance. The instance won\'t have an opportunity
to flush file system caches or file system metadata. If you use this
option, you must perform file system check and repair procedures.}

\item{InstanceId}{The ID of the instance.}

\item{VolumeId}{[required] The ID of the volume.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Detaches an EBS volume from an instance. Make sure to unmount any file
systems on the device within your operating system before detaching the
volume. Failure to do so can result in the volume becoming stuck in the
\code{busy} state while detaching. If this happens, detachment can be delayed
indefinitely until you unmount the volume, force detachment, reboot the
instance, or all three. If an EBS volume is the root device of an
instance, it can\'t be detached while the instance is running. To detach
the root volume, stop the instance first.
}
\details{
When a volume with an AWS Marketplace product code is detached from an
instance, the product code is no longer associated with the instance.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html}{Detaching an Amazon EBS Volume}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$detach_volume(
  Device = "string",
  Force = TRUE|FALSE,
  InstanceId = "string",
  VolumeId = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example detaches the volume (`vol-049df61146c4d7901`) from the
# instance it is attached to.
svc$detach_volume(
  VolumeId = "vol-1234567890abcdef0"
)
}

}
\keyword{internal}
