% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serverlessapplicationrepository_operations.R
\name{serverlessapplicationrepository_update_application}
\alias{serverlessapplicationrepository_update_application}
\title{Updates the specified application}
\usage{
serverlessapplicationrepository_update_application(
  ApplicationId,
  Author = NULL,
  Description = NULL,
  HomePageUrl = NULL,
  Labels = NULL,
  ReadmeBody = NULL,
  ReadmeUrl = NULL
)
}
\arguments{
\item{ApplicationId}{[required] The Amazon Resource Name (ARN) of the application.}

\item{Author}{The name of the author publishing the app.

Minimum length=1. Maximum length=127.

Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";}

\item{Description}{The description of the application.

Minimum length=1. Maximum length=256}

\item{HomePageUrl}{A URL with more information about the application, for example the
location of your GitHub repository for the application.}

\item{Labels}{Labels to improve discovery of apps in search results.

Minimum length=1. Maximum length=127. Maximum number of labels: 10

Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";}

\item{ReadmeBody}{A text readme file in Markdown language that contains a more detailed
description of the application and how it works.

Maximum size 5 MB}

\item{ReadmeUrl}{A link to the readme file in Markdown language that contains a more
detailed description of the application and how it works.

Maximum size 5 MB}
}
\description{
Updates the specified application.

See \url{https://paws-r.github.io/docs/serverlessapplicationrepository/update_application.html} for full documentation.
}
\keyword{internal}
