% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_disassociate_identity_provider_config}
\alias{eks_disassociate_identity_provider_config}
\title{Disassociates an identity provider configuration from a cluster}
\usage{
eks_disassociate_identity_provider_config(
  clusterName,
  identityProviderConfig,
  clientRequestToken = NULL
)
}
\arguments{
\item{clusterName}{[required] The name of the cluster to disassociate an identity provider from.}

\item{identityProviderConfig}{[required] An object representing an identity provider configuration.}

\item{clientRequestToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\description{
Disassociates an identity provider configuration from a cluster. If you disassociate an identity provider from your cluster, users included in the provider can no longer access the cluster. However, you can still access the cluster with Amazon Web Services IAM users.

See \url{https://www.paws-r-sdk.com/docs/eks_disassociate_identity_provider_config/} for full documentation.
}
\keyword{internal}
