# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include serverlessapplicationrepository_service.R
NULL

#' Creates an application, optionally including an AWS SAM file to create
#' the first application version in the same call
#'
#' @description
#' Creates an application, optionally including an AWS SAM file to create the first application version in the same call.
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_create_application/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_create_application/) for full documentation.
#'
#' @param Author &#91;required&#93; The name of the author publishing the app.
#'
#' Minimum length=1. Maximum length=127.
#'
#' Pattern "^\[a-z0-9\]((\[a-z0-9\]|-(?!-))*\[a-z0-9\])?$";
#' @param Description &#91;required&#93; The description of the application.
#'
#' Minimum length=1. Maximum length=256
#' @param HomePageUrl A URL with more information about the application, for example the
#' location of your GitHub repository for the application.
#' @param Labels Labels to improve discovery of apps in search results.
#'
#' Minimum length=1. Maximum length=127. Maximum number of labels: 10
#'
#' Pattern: "^\[a-zA-Z0-9+\\-_:\\/@@\]+$";
#' @param LicenseBody A local text file that contains the license of the app that matches the
#' spdxLicenseID value of your application. The file has the format
#' file://\<path\>/\<filename\>.
#'
#' Maximum size 5 MB
#'
#' You can specify only one of licenseBody and licenseUrl; otherwise, an
#' error results.
#' @param LicenseUrl A link to the S3 object that contains the license of the app that
#' matches the spdxLicenseID value of your application.
#'
#' Maximum size 5 MB
#'
#' You can specify only one of licenseBody and licenseUrl; otherwise, an
#' error results.
#' @param Name &#91;required&#93; The name of the application that you want to publish.
#'
#' Minimum length=1. Maximum length=140
#'
#' Pattern: "\[a-zA-Z0-9\\-\]+";
#' @param ReadmeBody A local text readme file in Markdown language that contains a more
#' detailed description of the application and how it works. The file has
#' the format file://\<path\>/\<filename\>.
#'
#' Maximum size 5 MB
#'
#' You can specify only one of readmeBody and readmeUrl; otherwise, an
#' error results.
#' @param ReadmeUrl A link to the S3 object in Markdown language that contains a more
#' detailed description of the application and how it works.
#'
#' Maximum size 5 MB
#'
#' You can specify only one of readmeBody and readmeUrl; otherwise, an
#' error results.
#' @param SemanticVersion The semantic version of the application:
#'
#' <https://semver.org/>
#' @param SourceCodeArchiveUrl A link to the S3 object that contains the ZIP archive of the source code
#' for this version of your application.
#'
#' Maximum size 50 MB
#' @param SourceCodeUrl A link to a public repository for the source code of your application,
#' for example the URL of a specific GitHub commit.
#' @param SpdxLicenseId A valid identifier from <https://spdx.org/licenses/>.
#' @param TemplateBody The local raw packaged AWS SAM template file of your application. The
#' file has the format file://\<path\>/\<filename\>.
#'
#' You can specify only one of templateBody and templateUrl; otherwise an
#' error results.
#' @param TemplateUrl A link to the S3 object containing the packaged AWS SAM template of your
#' application.
#'
#' You can specify only one of templateBody and templateUrl; otherwise an
#' error results.
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_create_application
serverlessapplicationrepository_create_application <- function(
  Author,
  Description,
  HomePageUrl = NULL,
  Labels = NULL,
  LicenseBody = NULL,
  LicenseUrl = NULL,
  Name,
  ReadmeBody = NULL,
  ReadmeUrl = NULL,
  SemanticVersion = NULL,
  SourceCodeArchiveUrl = NULL,
  SourceCodeUrl = NULL,
  SpdxLicenseId = NULL,
  TemplateBody = NULL,
  TemplateUrl = NULL
) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/applications",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$create_application_input(
    Author = Author,
    Description = Description,
    HomePageUrl = HomePageUrl,
    Labels = Labels,
    LicenseBody = LicenseBody,
    LicenseUrl = LicenseUrl,
    Name = Name,
    ReadmeBody = ReadmeBody,
    ReadmeUrl = ReadmeUrl,
    SemanticVersion = SemanticVersion,
    SourceCodeArchiveUrl = SourceCodeArchiveUrl,
    SourceCodeUrl = SourceCodeUrl,
    SpdxLicenseId = SpdxLicenseId,
    TemplateBody = TemplateBody,
    TemplateUrl = TemplateUrl
  )
  output <- .serverlessapplicationrepository$create_application_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$create_application <- serverlessapplicationrepository_create_application

#' Creates an application version
#'
#' @description
#' Creates an application version.
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_create_application_version/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_create_application_version/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param SemanticVersion &#91;required&#93; The semantic version of the new version.
#' @param SourceCodeArchiveUrl A link to the S3 object that contains the ZIP archive of the source code
#' for this version of your application.
#'
#' Maximum size 50 MB
#' @param SourceCodeUrl A link to a public repository for the source code of your application,
#' for example the URL of a specific GitHub commit.
#' @param TemplateBody The raw packaged AWS SAM template of your application.
#' @param TemplateUrl A link to the packaged AWS SAM template of your application.
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_create_application_version
serverlessapplicationrepository_create_application_version <- function(
  ApplicationId,
  SemanticVersion,
  SourceCodeArchiveUrl = NULL,
  SourceCodeUrl = NULL,
  TemplateBody = NULL,
  TemplateUrl = NULL
) {
  op <- new_operation(
    name = "CreateApplicationVersion",
    http_method = "PUT",
    http_path = "/applications/{applicationId}/versions/{semanticVersion}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$create_application_version_input(
    ApplicationId = ApplicationId,
    SemanticVersion = SemanticVersion,
    SourceCodeArchiveUrl = SourceCodeArchiveUrl,
    SourceCodeUrl = SourceCodeUrl,
    TemplateBody = TemplateBody,
    TemplateUrl = TemplateUrl
  )
  output <- .serverlessapplicationrepository$create_application_version_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$create_application_version <- serverlessapplicationrepository_create_application_version

#' Creates an AWS CloudFormation change set for the given application
#'
#' @description
#' Creates an AWS CloudFormation change set for the given application.
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_create_cloud_formation_change_set/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_create_cloud_formation_change_set/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param Capabilities A list of values that you must specify before you can deploy certain
#' applications. Some applications might include resources that can affect
#' permissions in your AWS account, for example, by creating new AWS
#' Identity and Access Management (IAM) users. For those applications, you
#' must explicitly acknowledge their capabilities by specifying this
#' parameter.
#'
#' The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM,
#' CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.
#'
#' The following resources require you to specify CAPABILITY_IAM or
#' CAPABILITY_NAMED_IAM:
#' [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html),
#' [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
#' [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html),
#' and
#' [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html).
#' If the application contains IAM resources, you can specify either
#' CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM
#' resources with custom names, you must specify CAPABILITY_NAMED_IAM.
#'
#' The following resources require you to specify
#' CAPABILITY_RESOURCE_POLICY:
#' [AWS::Lambda::Permission](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html),
#' [AWS::IAM:Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html),
#' [AWS::ApplicationAutoScaling::ScalingPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html),
#' [AWS::S3::BucketPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-bucketpolicy.html),
#' [AWS::SQS::QueuePolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queuepolicy.html),
#' and
#' [AWS::SNS:TopicPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topicpolicy.html).
#'
#' Applications that contain one or more nested applications require you to
#' specify CAPABILITY_AUTO_EXPAND.
#'
#' If your application template contains any of the above resources, we
#' recommend that you review all permissions associated with the
#' application before deploying. If you don't specify this parameter for an
#' application that requires capabilities, the call will fail.
#' @param ChangeSetName This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html}{CreateChangeSet}*
#' API.
#' @param ClientToken This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html}{CreateChangeSet}*
#' API.
#' @param Description This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html}{CreateChangeSet}*
#' API.
#' @param NotificationArns This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html}{CreateChangeSet}*
#' API.
#' @param ParameterOverrides A list of parameter values for the parameters of the application.
#' @param ResourceTypes This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html}{CreateChangeSet}*
#' API.
#' @param RollbackConfiguration This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html}{CreateChangeSet}*
#' API.
#' @param SemanticVersion The semantic version of the application:
#'
#' <https://semver.org/>
#' @param StackName &#91;required&#93; This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html}{CreateChangeSet}*
#' API.
#' @param Tags This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html}{CreateChangeSet}*
#' API.
#' @param TemplateId The UUID returned by CreateCloudFormationTemplate.
#'
#' Pattern:
#' \[0-9a-fA-F\]\{8\}\\-\[0-9a-fA-F\]\{4\}\\-\[0-9a-fA-F\]\{4\}\\-\[0-9a-fA-F\]\{4\}\\-\[0-9a-fA-F\]\{12\}
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_cre_clo_for_cha_set
serverlessapplicationrepository_create_cloud_formation_change_set <- function(
  ApplicationId,
  Capabilities = NULL,
  ChangeSetName = NULL,
  ClientToken = NULL,
  Description = NULL,
  NotificationArns = NULL,
  ParameterOverrides = NULL,
  ResourceTypes = NULL,
  RollbackConfiguration = NULL,
  SemanticVersion = NULL,
  StackName,
  Tags = NULL,
  TemplateId = NULL
) {
  op <- new_operation(
    name = "CreateCloudFormationChangeSet",
    http_method = "POST",
    http_path = "/applications/{applicationId}/changesets",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$create_cloud_formation_change_set_input(
    ApplicationId = ApplicationId,
    Capabilities = Capabilities,
    ChangeSetName = ChangeSetName,
    ClientToken = ClientToken,
    Description = Description,
    NotificationArns = NotificationArns,
    ParameterOverrides = ParameterOverrides,
    ResourceTypes = ResourceTypes,
    RollbackConfiguration = RollbackConfiguration,
    SemanticVersion = SemanticVersion,
    StackName = StackName,
    Tags = Tags,
    TemplateId = TemplateId
  )
  output <- .serverlessapplicationrepository$create_cloud_formation_change_set_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$create_cloud_formation_change_set <- serverlessapplicationrepository_create_cloud_formation_change_set

#' Creates an AWS CloudFormation template
#'
#' @description
#' Creates an AWS CloudFormation template.
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_create_cloud_formation_template/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_create_cloud_formation_template/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param SemanticVersion The semantic version of the application:
#'
#' <https://semver.org/>
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_cre_clo_for_tem
serverlessapplicationrepository_create_cloud_formation_template <- function(
  ApplicationId,
  SemanticVersion = NULL
) {
  op <- new_operation(
    name = "CreateCloudFormationTemplate",
    http_method = "POST",
    http_path = "/applications/{applicationId}/templates",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$create_cloud_formation_template_input(
    ApplicationId = ApplicationId,
    SemanticVersion = SemanticVersion
  )
  output <- .serverlessapplicationrepository$create_cloud_formation_template_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$create_cloud_formation_template <- serverlessapplicationrepository_create_cloud_formation_template

#' Deletes the specified application
#'
#' @description
#' Deletes the specified application.
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_delete_application/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_delete_application/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_delete_application
serverlessapplicationrepository_delete_application <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "DELETE",
    http_path = "/applications/{applicationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$delete_application_input(
    ApplicationId = ApplicationId
  )
  output <- .serverlessapplicationrepository$delete_application_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$delete_application <- serverlessapplicationrepository_delete_application

#' Gets the specified application
#'
#' @description
#' Gets the specified application.
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_get_application/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_get_application/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param SemanticVersion The semantic version of the application to get.
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_get_application
serverlessapplicationrepository_get_application <- function(
  ApplicationId,
  SemanticVersion = NULL
) {
  op <- new_operation(
    name = "GetApplication",
    http_method = "GET",
    http_path = "/applications/{applicationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$get_application_input(
    ApplicationId = ApplicationId,
    SemanticVersion = SemanticVersion
  )
  output <- .serverlessapplicationrepository$get_application_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$get_application <- serverlessapplicationrepository_get_application

#' Retrieves the policy for the application
#'
#' @description
#' Retrieves the policy for the application.
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_get_application_policy/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_get_application_policy/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_get_application_policy
serverlessapplicationrepository_get_application_policy <- function(
  ApplicationId
) {
  op <- new_operation(
    name = "GetApplicationPolicy",
    http_method = "GET",
    http_path = "/applications/{applicationId}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$get_application_policy_input(
    ApplicationId = ApplicationId
  )
  output <- .serverlessapplicationrepository$get_application_policy_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$get_application_policy <- serverlessapplicationrepository_get_application_policy

#' Gets the specified AWS CloudFormation template
#'
#' @description
#' Gets the specified AWS CloudFormation template.
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_get_cloud_formation_template/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_get_cloud_formation_template/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param TemplateId &#91;required&#93; The UUID returned by CreateCloudFormationTemplate.
#'
#' Pattern:
#' \[0-9a-fA-F\]\{8\}\\-\[0-9a-fA-F\]\{4\}\\-\[0-9a-fA-F\]\{4\}\\-\[0-9a-fA-F\]\{4\}\\-\[0-9a-fA-F\]\{12\}
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_get_cloud_formation_template
serverlessapplicationrepository_get_cloud_formation_template <- function(
  ApplicationId,
  TemplateId
) {
  op <- new_operation(
    name = "GetCloudFormationTemplate",
    http_method = "GET",
    http_path = "/applications/{applicationId}/templates/{templateId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$get_cloud_formation_template_input(
    ApplicationId = ApplicationId,
    TemplateId = TemplateId
  )
  output <- .serverlessapplicationrepository$get_cloud_formation_template_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$get_cloud_formation_template <- serverlessapplicationrepository_get_cloud_formation_template

#' Retrieves the list of applications nested in the containing application
#'
#' @description
#' Retrieves the list of applications nested in the containing application.
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_list_application_dependencies/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_list_application_dependencies/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param MaxItems The total number of items to return.
#' @param NextToken A token to specify where to start paginating.
#' @param SemanticVersion The semantic version of the application to get.
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_lis_app_dep
serverlessapplicationrepository_list_application_dependencies <- function(
  ApplicationId,
  MaxItems = NULL,
  NextToken = NULL,
  SemanticVersion = NULL
) {
  op <- new_operation(
    name = "ListApplicationDependencies",
    http_method = "GET",
    http_path = "/applications/{applicationId}/dependencies",
    host_prefix = "",
    paginator = list(
      input_token = "NextToken",
      limit_key = "MaxItems",
      output_token = "NextToken",
      result_key = "Dependencies"
    ),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$list_application_dependencies_input(
    ApplicationId = ApplicationId,
    MaxItems = MaxItems,
    NextToken = NextToken,
    SemanticVersion = SemanticVersion
  )
  output <- .serverlessapplicationrepository$list_application_dependencies_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$list_application_dependencies <- serverlessapplicationrepository_list_application_dependencies

#' Lists versions for the specified application
#'
#' @description
#' Lists versions for the specified application.
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_list_application_versions/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_list_application_versions/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param MaxItems The total number of items to return.
#' @param NextToken A token to specify where to start paginating.
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_list_application_versions
serverlessapplicationrepository_list_application_versions <- function(
  ApplicationId,
  MaxItems = NULL,
  NextToken = NULL
) {
  op <- new_operation(
    name = "ListApplicationVersions",
    http_method = "GET",
    http_path = "/applications/{applicationId}/versions",
    host_prefix = "",
    paginator = list(
      input_token = "NextToken",
      limit_key = "MaxItems",
      output_token = "NextToken",
      result_key = "Versions"
    ),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$list_application_versions_input(
    ApplicationId = ApplicationId,
    MaxItems = MaxItems,
    NextToken = NextToken
  )
  output <- .serverlessapplicationrepository$list_application_versions_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$list_application_versions <- serverlessapplicationrepository_list_application_versions

#' Lists applications owned by the requester
#'
#' @description
#' Lists applications owned by the requester.
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_list_applications/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_list_applications/) for full documentation.
#'
#' @param MaxItems The total number of items to return.
#' @param NextToken A token to specify where to start paginating.
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_list_applications
serverlessapplicationrepository_list_applications <- function(
  MaxItems = NULL,
  NextToken = NULL
) {
  op <- new_operation(
    name = "ListApplications",
    http_method = "GET",
    http_path = "/applications",
    host_prefix = "",
    paginator = list(
      input_token = "NextToken",
      limit_key = "MaxItems",
      output_token = "NextToken",
      result_key = "Applications"
    ),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$list_applications_input(
    MaxItems = MaxItems,
    NextToken = NextToken
  )
  output <- .serverlessapplicationrepository$list_applications_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$list_applications <- serverlessapplicationrepository_list_applications

#' Sets the permission policy for an application
#'
#' @description
#' Sets the permission policy for an application. For the list of actions supported for this operation, see [Application Permissions](https://docs.aws.amazon.com/serverlessrepo/latest/devguide/security_iam_resource-based-policy-examples.html#application-permissions) .
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_put_application_policy/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_put_application_policy/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param Statements &#91;required&#93; An array of policy statements applied to the application.
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_put_application_policy
serverlessapplicationrepository_put_application_policy <- function(
  ApplicationId,
  Statements
) {
  op <- new_operation(
    name = "PutApplicationPolicy",
    http_method = "PUT",
    http_path = "/applications/{applicationId}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$put_application_policy_input(
    ApplicationId = ApplicationId,
    Statements = Statements
  )
  output <- .serverlessapplicationrepository$put_application_policy_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$put_application_policy <- serverlessapplicationrepository_put_application_policy

#' Unshares an application from an AWS Organization
#'
#' @description
#' Unshares an application from an AWS Organization.
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_unshare_application/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_unshare_application/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param OrganizationId &#91;required&#93; The AWS Organization ID to unshare the application from.
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_unshare_application
serverlessapplicationrepository_unshare_application <- function(
  ApplicationId,
  OrganizationId
) {
  op <- new_operation(
    name = "UnshareApplication",
    http_method = "POST",
    http_path = "/applications/{applicationId}/unshare",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$unshare_application_input(
    ApplicationId = ApplicationId,
    OrganizationId = OrganizationId
  )
  output <- .serverlessapplicationrepository$unshare_application_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$unshare_application <- serverlessapplicationrepository_unshare_application

#' Updates the specified application
#'
#' @description
#' Updates the specified application.
#'
#' See [https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_update_application/](https://www.paws-r-sdk.com/docs/serverlessapplicationrepository_update_application/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param Author The name of the author publishing the app.
#'
#' Minimum length=1. Maximum length=127.
#'
#' Pattern "^\[a-z0-9\]((\[a-z0-9\]|-(?!-))*\[a-z0-9\])?$";
#' @param Description The description of the application.
#'
#' Minimum length=1. Maximum length=256
#' @param HomePageUrl A URL with more information about the application, for example the
#' location of your GitHub repository for the application.
#' @param Labels Labels to improve discovery of apps in search results.
#'
#' Minimum length=1. Maximum length=127. Maximum number of labels: 10
#'
#' Pattern: "^\[a-zA-Z0-9+\\-_:\\/@@\]+$";
#' @param ReadmeBody A text readme file in Markdown language that contains a more detailed
#' description of the application and how it works.
#'
#' Maximum size 5 MB
#' @param ReadmeUrl A link to the readme file in Markdown language that contains a more
#' detailed description of the application and how it works.
#'
#' Maximum size 5 MB
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_update_application
serverlessapplicationrepository_update_application <- function(
  ApplicationId,
  Author = NULL,
  Description = NULL,
  HomePageUrl = NULL,
  Labels = NULL,
  ReadmeBody = NULL,
  ReadmeUrl = NULL
) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "PATCH",
    http_path = "/applications/{applicationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .serverlessapplicationrepository$update_application_input(
    ApplicationId = ApplicationId,
    Author = Author,
    Description = Description,
    HomePageUrl = HomePageUrl,
    Labels = Labels,
    ReadmeBody = ReadmeBody,
    ReadmeUrl = ReadmeUrl
  )
  output <- .serverlessapplicationrepository$update_application_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$update_application <- serverlessapplicationrepository_update_application
