% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeoptimizer_operations.R
\name{computeoptimizer_get_ec2_recommendation_projected_metrics}
\alias{computeoptimizer_get_ec2_recommendation_projected_metrics}
\title{Returns the projected utilization metrics of Amazon EC2 instance
recommendations}
\usage{
computeoptimizer_get_ec2_recommendation_projected_metrics(
  instanceArn,
  stat,
  period,
  startTime,
  endTime,
  recommendationPreferences = NULL
)
}
\arguments{
\item{instanceArn}{[required] The Amazon Resource Name (ARN) of the instances for which to return
recommendation projected metrics.}

\item{stat}{[required] The statistic of the projected metrics.}

\item{period}{[required] The granularity, in seconds, of the projected metrics data points.}

\item{startTime}{[required] The timestamp of the first projected metrics data point to return.}

\item{endTime}{[required] The timestamp of the last projected metrics data point to return.}

\item{recommendationPreferences}{An object to specify the preferences for the Amazon EC2 recommendation
projected metrics to return in the response.}
}
\description{
Returns the projected utilization metrics of Amazon EC2 instance recommendations.

See \url{https://www.paws-r-sdk.com/docs/computeoptimizer_get_ec2_recommendation_projected_metrics/} for full documentation.
}
\keyword{internal}
