% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_default_credit_specification}
\alias{ec2_modify_default_credit_specification}
\title{Modifies the default credit option for CPU usage of burstable
performance instances}
\usage{
ec2_modify_default_credit_specification(
  DryRun = NULL,
  InstanceFamily,
  CpuCredits
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the operation,
without actually making the request, and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceFamily}{[required] The instance family.}

\item{CpuCredits}{[required] The credit option for CPU usage of the instance family.

Valid Values: \code{standard} | \code{unlimited}}
}
\description{
Modifies the default credit option for CPU usage of burstable performance instances. The default credit option is set at the account level per Amazon Web Services Region, and is specified per instance family. All new burstable performance instances in the account launch using the default credit option.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_default_credit_specification/} for full documentation.
}
\keyword{internal}
