% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_cost_categories}
\alias{costexplorer_get_cost_categories}
\title{Retrieves an array of Cost Category names and values incurred cost}
\usage{
costexplorer_get_cost_categories(SearchString, TimePeriod,
  CostCategoryName, Filter, SortBy, MaxResults, NextPageToken)
}
\arguments{
\item{SearchString}{The value that you want to search the filter values for.

If you do not specify a \code{CostCategoryName}, \code{SearchString} will be used
to filter Cost Category names that match the \code{SearchString} pattern. If
you do specifiy a \code{CostCategoryName}, \code{SearchString} will be used to
filter Cost Category values that match the \code{SearchString} pattern.}

\item{TimePeriod}{[required]}

\item{CostCategoryName}{}

\item{Filter}{}

\item{SortBy}{The value by which you want to sort the data.

The key represents cost and usage metrics. The following values are
supported:
\itemize{
\item \code{BlendedCost}
\item \code{UnblendedCost}
\item \code{AmortizedCost}
\item \code{NetAmortizedCost}
\item \code{NetUnblendedCost}
\item \code{UsageQuantity}
\item \code{NormalizedUsageAmount}
}

Supported values for \code{SortOrder} are \code{ASCENDING} or \code{DESCENDING}.

When using \code{SortBy}, \code{NextPageToken} and \code{SearchString} are not
supported.}

\item{MaxResults}{This field is only used when \code{SortBy} is provided in the request.

The maximum number of objects that to be returned for this request. If
\code{MaxResults} is not specified with \code{SortBy}, the request will return
1000 results as the default value for this parameter.}

\item{NextPageToken}{If the number of objects that are still available for retrieval exceeds
the limit, AWS returns a NextPageToken value in the response. To
retrieve the next batch of objects, provide the NextPageToken from the
prior call in your next request.}
}
\description{
Retrieves an array of Cost Category names and values incurred cost.

If some Cost Category names and values are not associated with any cost,
they will not be returned by this API.
}
\section{Request syntax}{
\preformatted{svc$get_cost_categories(
  SearchString = "string",
  TimePeriod = list(
    Start = "string",
    End = "string"
  ),
  CostCategoryName = "string",
  Filter = list(
    Or = list(
      list()
    ),
    And = list(
      list()
    ),
    Not = list(),
    Dimensions = list(
      Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
      Values = list(
        "string"
      ),
      MatchOptions = list(
        "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
      )
    ),
    Tags = list(
      Key = "string",
      Values = list(
        "string"
      ),
      MatchOptions = list(
        "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
      )
    ),
    CostCategories = list(
      Key = "string",
      Values = list(
        "string"
      ),
      MatchOptions = list(
        "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
      )
    )
  ),
  SortBy = list(
    list(
      Key = "string",
      SortOrder = "ASCENDING"|"DESCENDING"
    )
  ),
  MaxResults = 123,
  NextPageToken = "string"
)
}
}

\keyword{internal}
