% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_update_anomaly_subscription}
\alias{costexplorer_update_anomaly_subscription}
\title{Updates an existing cost anomaly monitor subscription}
\usage{
costexplorer_update_anomaly_subscription(SubscriptionArn, Threshold,
  Frequency, MonitorArnList, Subscribers, SubscriptionName)
}
\arguments{
\item{SubscriptionArn}{[required] A cost anomaly subscription Amazon Resource Name (ARN).}

\item{Threshold}{The update to the threshold value for receiving notifications.}

\item{Frequency}{The update to the frequency value at which subscribers will receive
notifications.}

\item{MonitorArnList}{A list of cost anomaly monitor ARNs.}

\item{Subscribers}{The update to the subscriber list.}

\item{SubscriptionName}{The subscription's new name.}
}
\description{
Updates an existing cost anomaly monitor subscription.
}
\section{Request syntax}{
\preformatted{svc$update_anomaly_subscription(
  SubscriptionArn = "string",
  Threshold = 123.0,
  Frequency = "DAILY"|"IMMEDIATE"|"WEEKLY",
  MonitorArnList = list(
    "string"
  ),
  Subscribers = list(
    list(
      Address = "string",
      Type = "EMAIL"|"SNS",
      Status = "CONFIRMED"|"DECLINED"
    )
  ),
  SubscriptionName = "string"
)
}
}

\keyword{internal}
