% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_list_queues}
\alias{connect_list_queues}
\title{Provides information about the queues for the specified Amazon Connect
instance}
\usage{
connect_list_queues(InstanceId, QueueTypes, NextToken, MaxResults)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{QueueTypes}{The type of queue.}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{The maximimum number of results to return per page.}
}
\description{
Provides information about the queues for the specified Amazon Connect
instance.

For more information about queues, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html}{Queues: Standard and Agent}
in the \emph{Amazon Connect Administrator Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_queues(
  InstanceId = "string",
  QueueTypes = list(
    "STANDARD"|"AGENT"
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
