% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointsmsvoice_operations.R
\name{pinpointsmsvoice_create_configuration_set_event_destination}
\alias{pinpointsmsvoice_create_configuration_set_event_destination}
\title{Create a new event destination in a configuration set}
\usage{
pinpointsmsvoice_create_configuration_set_event_destination(
  ConfigurationSetName, EventDestination, EventDestinationName)
}
\arguments{
\item{ConfigurationSetName}{[required] ConfigurationSetName}

\item{EventDestination}{}

\item{EventDestinationName}{A name that identifies the event destination.}
}
\description{
Create a new event destination in a configuration set.
}
\section{Request syntax}{
\preformatted{svc$create_configuration_set_event_destination(
  ConfigurationSetName = "string",
  EventDestination = list(
    CloudWatchLogsDestination = list(
      IamRoleArn = "string",
      LogGroupArn = "string"
    ),
    Enabled = TRUE|FALSE,
    KinesisFirehoseDestination = list(
      DeliveryStreamArn = "string",
      IamRoleArn = "string"
    ),
    MatchingEventTypes = list(
      "INITIATED_CALL"|"RINGING"|"ANSWERED"|"COMPLETED_CALL"|"BUSY"|"FAILED"|"NO_ANSWER"
    ),
    SnsDestination = list(
      TopicArn = "string"
    )
  ),
  EventDestinationName = "string"
)
}
}

\keyword{internal}
