% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointemail_operations.R
\name{pinpointemail_get_domain_deliverability_campaign}
\alias{pinpointemail_get_domain_deliverability_campaign}
\title{Retrieve all the deliverability data for a specific campaign}
\usage{
pinpointemail_get_domain_deliverability_campaign(CampaignId)
}
\arguments{
\item{CampaignId}{[required] The unique identifier for the campaign. Amazon Pinpoint automatically
generates and assigns this identifier to a campaign. This value is not
the same as the campaign identifier that Amazon Pinpoint assigns to
campaigns that you create and manage by using the Amazon Pinpoint API or
the Amazon Pinpoint console.}
}
\value{
A list with the following syntax:\preformatted{list(
  DomainDeliverabilityCampaign = list(
    CampaignId = "string",
    ImageUrl = "string",
    Subject = "string",
    FromAddress = "string",
    SendingIps = list(
      "string"
    ),
    FirstSeenDateTime = as.POSIXct(
      "2015-01-01"
    ),
    LastSeenDateTime = as.POSIXct(
      "2015-01-01"
    ),
    InboxCount = 123,
    SpamCount = 123,
    ReadRate = 123.0,
    DeleteRate = 123.0,
    ReadDeleteRate = 123.0,
    ProjectedVolume = 123,
    Esps = list(
      "string"
    )
  )
)
}
}
\description{
Retrieve all the deliverability data for a specific campaign. This data
is available for a campaign only if the campaign sent email by using a
domain that the Deliverability dashboard is enabled for
(\code{\link[=pinpointemail_put_deliverability_dashboard_option]{put_deliverability_dashboard_option}}
operation).
}
\section{Request syntax}{
\preformatted{svc$get_domain_deliverability_campaign(
  CampaignId = "string"
)
}
}

\keyword{internal}
