% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointemail_operations.R
\name{pinpointemail_put_email_identity_mail_from_attributes}
\alias{pinpointemail_put_email_identity_mail_from_attributes}
\title{Used to enable or disable the custom Mail-From domain configuration for
an email identity}
\usage{
pinpointemail_put_email_identity_mail_from_attributes(EmailIdentity,
  MailFromDomain, BehaviorOnMxFailure)
}
\arguments{
\item{EmailIdentity}{[required] The verified email identity that you want to set up the custom MAIL FROM
domain for.}

\item{MailFromDomain}{The custom MAIL FROM domain that you want the verified identity to use.
The MAIL FROM domain must meet the following criteria:
\itemize{
\item It has to be a subdomain of the verified identity.
\item It can\'t be used to receive email.
\item It can\'t be used in a \"From\" address if the MAIL FROM domain is a
destination for feedback forwarding emails.
}}

\item{BehaviorOnMxFailure}{The action that you want Amazon Pinpoint to take if it can\'t read the
required MX record when you send an email. When you set this value to
\code{UseDefaultValue}, Amazon Pinpoint uses \emph{amazonses.com} as the MAIL FROM
domain. When you set this value to \code{RejectMessage}, Amazon Pinpoint
returns a \code{MailFromDomainNotVerified} error, and doesn\'t attempt to
deliver the email.

These behaviors are taken when the custom MAIL FROM domain configuration
is in the \code{Pending}, \code{Failed}, and \code{TemporaryFailure} states.}
}
\description{
Used to enable or disable the custom Mail-From domain configuration for
an email identity.
}
\section{Request syntax}{
\preformatted{svc$put_email_identity_mail_from_attributes(
  EmailIdentity = "string",
  MailFromDomain = "string",
  BehaviorOnMxFailure = "USE_DEFAULT_VALUE"|"REJECT_MESSAGE"
)
}
}

\keyword{internal}
