% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointsmsvoicev2_operations.R
\name{pinpointsmsvoicev2_send_text_message}
\alias{pinpointsmsvoicev2_send_text_message}
\title{Creates a new text message and sends it to a recipient's phone number}
\usage{
pinpointsmsvoicev2_send_text_message(
  DestinationPhoneNumber,
  OriginationIdentity = NULL,
  MessageBody = NULL,
  MessageType = NULL,
  Keyword = NULL,
  ConfigurationSetName = NULL,
  MaxPrice = NULL,
  TimeToLive = NULL,
  Context = NULL,
  DestinationCountryParameters = NULL,
  DryRun = NULL
)
}
\arguments{
\item{DestinationPhoneNumber}{[required] The destination phone number in E.164 format.}

\item{OriginationIdentity}{The origination identity of the message. This can be either the
PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn,
PoolId, or PoolArn.}

\item{MessageBody}{The body of the text message.}

\item{MessageType}{The type of message. Valid values are TRANSACTIONAL for messages that
are critical or time-sensitive and PROMOTIONAL for messages that aren't
critical or time-sensitive.}

\item{Keyword}{When you register a short code in the US, you must specify a program
name. If you don’t have a US short code, omit this attribute.}

\item{ConfigurationSetName}{The name of the configuration set to use. This can be either the
ConfigurationSetName or ConfigurationSetArn.}

\item{MaxPrice}{The maximum amount that you want to spend, in US dollars, per each text
message part. A text message can contain multiple parts.}

\item{TimeToLive}{How long the text message is valid for. By default this is 72 hours.}

\item{Context}{You can specify custom data in this field. If you do, that data is
logged to the event destination.}

\item{DestinationCountryParameters}{This field is used for any country-specific registration requirements.
Currently, this setting is only used when you send messages to
recipients in India using a sender ID. For more information see \href{https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html}{Special requirements for sending SMS messages to recipients in India}.}

\item{DryRun}{When set to true, the message is checked and validated, but isn't sent
to the end recipient.}
}
\description{
Creates a new text message and sends it to a recipient's phone number.

See \url{https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_send_text_message/} for full documentation.
}
\keyword{internal}
